//渲染每一个人员item
/**
 * 通过搜索获得地图列表(保安人员)
 */
import React, { Component } from "react";
import { connect } from "dva";
import { Pagination, message, Icon, Modal, Button, Tooltip } from "antd";
// import "../person.less";
// import { getComPerLocationByKeyword } from "../../../../../services/api";
const { confirm } = Modal;
@connect((state) => ({
  selectedId: state.command.personList.selectedId,
  //   tabIndex2: state.command.tabIndex.person.tabIndex2,
}))
export default class PersonItem extends Component {
  constructor(props) {
    super(props);
    this.state = {
      data: props.data || [],
      noNeedComName: props.noNeedComName,
      loadingText: props.data,
    };
  }

  componentDidMount() {}
  componentWillReceiveProps(nextProps) {
    this.setState({
      loadingText: nextProps.loadingText,
    });
    if (nextProps.data != this.state.data) {
      this.setState({
        data: nextProps.data,
      });
    }
  }
  render() {
    return (
      <div>
        {this.state.data.length > 0 ? (
          this.state.data.map((item, index) => {
            const xing = "********";
            let idCardNo = "";
            if (item.idCardNo) {
              let front6 = item.idCardNo.substring(0, 6);
              idCardNo =
                front6 +
                xing +
                item.idCardNo.substring(14, item.idCardNo.length);
            }
            return (
              <div
                key={index}
                className="item"
                onClick={() => {
                  if (item.lnglat) {
                    // if (this.props.selectedId != item.perId) {
                    this.props.dispatch({
                      type: "command/setPersonSelectIndex",
                      payload: item.perId,
                    });
                  } else {
                    message.warning("该人员暂未定位");
                  }
                }}
                // onMouseOver={() => {
                //   this.props.dispatch({
                //     type: "command/setPersonHoverIndex",
                //     payload: item.perId,
                //   });
                // }}
                // onMouseLeave={() => {
                //   this.props.dispatch({
                //     type: "command/setPersonHoverIndex",
                //     payload: null,
                //   });
                // }}
              >
                <div
                  className={
                    this.props.selectedId === item.perId
                      ? "selected poibox"
                      : "poibox"
                  }
                >
                  {item.photoUrl ? (
                    <img
                      className="img"
                      src={item.photoUrl ? item.photoUrl : ""}
                    ></img>
                  ) : (
                    <div className="img-span">
                      {/* 取后面两位显示 */}
                      <span>
                        {item.name
                          ? item.name.substring(
                              item.name.length - 2,
                              item.name.length
                            )
                          : ""}
                      </span>
                    </div>
                  )}

                  <div style={{ marginLeft: 45 }}>
                    <div className="name">
                      {item.name || "---"}
                      <span className="send-header-bar">
                        <Tooltip placement="bottom" title="文字调度">
                          <Icon
                            type="form"
                            style={{ fontSize: "17px" }}
                            onClick={(e) => {
                              e.stopPropagation(), //合成事件停止冒泡
                                this.props.clickTextScheduling(item, "text");
                            }}
                          />
                        </Tooltip>
                        <Tooltip
                          placement="bottom"
                          title="语音调度"
                          onClick={(e) => {
                            e.stopPropagation(), //合成事件停止冒泡
                              this.props.clickTextScheduling(item, "voice");
                          }}
                        >
                          <Icon type="audio" style={{ fontSize: "17px" }} />
                        </Tooltip>
                        <Tooltip
                          placement="bottom"
                          title="视频调度"
                          onClick={(e) => {
                            const _this = this;
                            e.stopPropagation(), //合成事件停止冒泡
                              confirm({
                                // title: "是否立即启动调度?",
                                title: "是否开启屏幕录制?",
                                content:
                                  "开启后，被调度保安员的视频页面将会被录制，调度结束后，可查看录制文件。",
                                okText: "开启录制,继续调度",
                                cancelText: "不开启录制,继续调度",
                                onOk() {
                                  _this.props.clickTextScheduling(item, "video", [item.mobilePhone]);
                                },
                                onCancel() {
                                  _this.props.clickTextScheduling(item, "video");
                                },
                              });
                          }}
                        >
                          <Icon
                            type="video-camera"
                            style={{ fontSize: "17px" }}
                          />
                        </Tooltip>
                      </span>
                    </div>
                    <div className="text">
                      手机号码:{item.mobilePhone || "---"}
                    </div>
                    <div className="text">
                      证件号码:{idCardNo || "---"}
                      {item.lnglat && (
                        <div
                          className="amap_lib_placeSearch_poi poibox-icon"
                          style={{ marginTop: "-15px" }}
                        >
                          {index}
                        </div>
                      )}
                    </div>
                    {!this.state.noNeedComName && (
                      <div className="text">
                        所属企业:{item.comName || "---"}
                      </div>
                    )}
                  </div>
                </div>
              </div>
            );
          })
        ) : (
          <div
            style={{ textAlign: "center", fontSize: "14px", color: "#afb0b1" }}
          >
            {this.state.loadingText || "暂无数据"}
          </div>
        )}
      </div>
    );
  }
}
