/**
 * 保安人员的搜索列表
 */
import React, { Component } from "react";
import "./attendance.less";
import { getComTaskPerLocation } from "../../../../../services/api";
import PersonItem from "../PersonMessage/PersonItem";
import { message, Button } from "antd";
import { connect } from "dva";

@connect((state) => ({
  selectedAttenData: state.command.attendanceList.selectedAttenData,
  selectedId: state.command.personList.selectedId,
}))
export default class PersonSearchList extends Component {
  constructor(props) {
    super(props);
    this.state = {
      pageSize: 20,
      comTaskId: props.selectedAttenData.comTaskId,
      total: 0, //搜索总条数
      // selectedAttenData: props.selectedAttenData || null, //传过来选中的驻勤点的信息
      attenPersonList: [], //保安员列表
      height: null, //人员列表的最大高度
    };
  }

  componentDidMount() {
    this.getPersonList(this.props.selectedAttenData.comTaskId);
    const height = document.documentElement.clientHeight - 120 - 130 - 160 - 63;
    this.setState({ height });
  }
  componentWillReceiveProps(nextProps) {
    if (
      this.props.selectedAttenData.comTaskId !==
      nextProps.selectedAttenData.comTaskId
    ) {
      this.getPersonList(nextProps.selectedAttenData.comTaskId);
    }
  }
  //获取驻勤点对应的保安员列表
  getPersonList(comTaskId, pageNumber = 1, pageSize = this.state.pageSize) {
    getComTaskPerLocation({
      pageNumber,
      pageSize,
      comTaskId,
    }).then((res) => {
      if (res.retType === "0") {
        if (res.data.data.length > 0) {
          // this.props.attenPersonList(res.data.data);
          this.setState({
            attenPersonList: res.data.data,
            total: res.data.total,
          });
          this.props.dispatch({
            type: "command/fetchPersonList",
            payload: {
              list: res.data.data,
            },
          });
        } else {
          message.warning("该驻勤点没有人员");
        }
      }
    });
  }
  render() {
    return (
      <div className="attendance-person search-list_command amap_lib_placeSearch">
        <div className="security-personnel">
          <span>
            {this.props.selectedAttenData &&
              this.props.selectedAttenData.taskName}
          </span>
          <Button
            className="close"
            onClick={() => {
              this.props.dispatch({
                type: "command/setSelectedAttenData",
                payload: null,
              });
              this.props.dispatch({
                type: "command/fetchPersonList",
                payload: {
                  list: [],
                },
              });
              this.props.dispatch({
                type: "command/clearInfoWindow",
                payload: true,
              });
            }}
          >
            返回
          </Button>
          {/* <span
            className="close"
            onClick={() => {
              this.props.dispatch({
                type: "command/setSelectedAttenData",
                payload: null,
              });
              this.props.dispatch({
                type: "command/fetchPersonList",
                payload: {
                  list: [],
                },
              });
              this.props.dispatch({
                type: 'command/clearInfoWindow',
                payload: true
              })
            }}
          >
            x
          </span> */}
        </div>
        <div className="list">
          <div className="item attendance-detail">
            <div>所属企业:{this.props.selectedAttenData.comName}</div>
            <div>负责人:{this.props.selectedAttenData.name}</div>
            <div>身份证号:{this.props.selectedAttenData.idCardNo}</div>
            <div>手机号码:{this.props.selectedAttenData.mobilePhone}</div>
            <div>地址:{this.props.selectedAttenData.taskAddress}</div>
            <div>保安员数量:{this.props.selectedAttenData.perNum}名</div>
            <div>
              服务企业类型:
              {this.props.selectedAttenData.serviceObjectTypeName || "-"}
            </div>
          </div>
          <div className="search-list_command">
            <div className="list" style={{ maxHeight: this.state.height }}>
              <PersonItem
                data={this.state.attenPersonList}
                clickTextScheduling={(item, type, recordMobile) => {
                  this.props.clickTextScheduling(item, type, recordMobile);
                }}
                noNeedComName={true} //不需要展示所属企业字段
              />
            </div>
          </div>
        </div>
        <div
          className="see-more"
          style={{
            display:
              this.state.total > this.state.attenPersonList.length
                ? "block"
                : "none",
          }}
        >
          <span
            onClick={() => {
              this.getPersonList(this.state.comTaskId, 1, this.state.total);
            }}
          >
            查看更多
          </span>
        </div>
      </div>
    );
  }
}
