/**
 * 地图页面
 */
import React, { PureComponent } from "react";
import style from "styled-components";
import { connect } from "dva";
import { Form, Layout, Menu, Switch } from "antd";
import HeaderMenu from "./Header";
import { CommandRouter } from "./Router";
@connect((state) => ({}))
@Form.create()
export default class Command extends PureComponent {
  constructor(props) {
    super(props);
    this.state = {
      path: "GIS",
    };
  }

  /******************************生命周期******************************/
  componentDidMount() {
    if (document.querySelector(".ant-layout-header")) {
      // 隐藏左侧菜单栏
      document.querySelector(".ant-layout-sider").style.display = "none";
      document.querySelector(".ant-layout-content").style.margin = "0px";
      document.querySelector(".oneKeySearchHidden").style.display = "none";
      //隐藏顶部菜单栏
      document.querySelector(".ant-layout-header").style.display = "none";
    }
  }
  componentWillReceiveProps(nextProps) {
    // document.querySelector(".ant-layout-sider").style.display = "none";
  }
  componentWillUnmount() {
    if (document.querySelector(".ant-layout-sider")) {
      // 显示左侧菜单栏
      document.querySelector(".ant-layout-sider").style.display = "block";
      document.querySelector(".ant-layout-content").style.margin = "16px";
      document.querySelector(".oneKeySearchHidden").style.display = "block";
    }
  }

  /******************************相关事件******************************/
  render() {
    return (
      <div>
        <HeaderMenu
          currentRouter={(item) => {
            this.setState({ path: item.path });
          }}
        ></HeaderMenu>
        <div
          style={{
            // height: "calc(100vh - 54px)",
            height: "calc(100vh)",
            paddingTop: this.state.path == "GIS" ? "0" : "54px",
          }}
        >
          {CommandRouter.map((item) => {
            if (item.path == this.state.path) {
              return item.component;
            }
          })}
        </div>
      </div>
    );
  }
}

