/**
 * 视频通话页面
 */
import React, { Component } from "react";
import { connect } from "dva";
import { Pagination, Drawer, Tooltip, Modal, Row, Col, Button } from "antd";
import "./video.less";
import CheckRTC from "./checkRTC";
import "./popper";
// import Presetting from './presetting';
import Common from "./common";
// import { imKey } from "../../../utils/config";
import { trtcVideoRoom, getTencentYspSig } from "../../../services/api";
@connect((state) => ({
  // imIsLogin: state.im.imIsLogin
}))
export default class Video extends Component {
  constructor(props) {
    super(props);
    this.common = Common.call(this);
    this.state = {
      RTC: null,
      Room_No: props.Room_No, //房间号
      // MemberList: props.MemberList,
      mobilePhone: props.mobilePhone,
      imSig: props.imSig,
      height: null,
      schedulingName: props.schedulingName, //调度任务名称
      rtc: null,
      isCamOn: true,
      isMicOn: true,
    };
  }

  componentDidMount() {
    CheckRTC();
    const height = document.documentElement.clientHeight - 5;
    this.setState({
      height,
    });
    this.common.login(this.state.Room_No, this.state.mobilePhone);
  }
  //解散房间
  dissolutionRoom() {
    // window.close();
    trtcVideoRoom({ Room_No: this.state.Room_No }).then((res) => {
      console.log(res);
    });
  }
  render() {
    return (
      <div>
        <div className="ant-modal-mask" style={{ zIndex: 100 }}></div>
        <div id="video-section">
          <div className="text" ref="text" style={{ width: "70%" }}>
            {/* <span id="c_schedulingName">{this.state.schedulingName} </span> */}
            <span id="c_roomid">房间ID：{this.state.Room_No} </span>
            <Button
              className="btn-dissolve"
              type="button"
              onClick={() => {
                const _this = this;
                Modal.confirm({
                  title: "您将解散房间?",
                  content: "注：其他人员也将退出房间",
                  okText: "确定",
                  cancelText: "取消",
                  onOk() {
                    // this.quitRTC();
                    _this.common.leave(_this.state.Room_No);
                    _this.dissolutionRoom();
                    setTimeout(() => {
                      _this.props.closeVideoState();
                    }, 200);
                  },
                  onCancel() {
                    console.log("Cancel");
                  },
                });
              }}
            >
              解散群聊
            </Button>
            <Button
              className="btn-dissolve"
              type="button"
              onClick={() => {
                const _this = this;
                Modal.confirm({
                  title: "您将离开房间?",
                  content: "注：其他人员还可以继续视频",
                  okText: "确定",
                  cancelText: "取消",
                  onOk() {
                    _this.common.leave(_this.state.Room_No);
                    setTimeout(() => {
                      _this.props.closeVideoState();
                    }, 200);
                  },
                  onCancel() {
                    console.log("Cancel");
                  },
                });
              }}
            >
              离开
            </Button>
            <img
              id="screen-btn"
              style={{ width: "65px", height: "65px", marginLeft: "10px" }}
              src="./img/screen-off.png"
              src={require("../../../assets/images/prevention/screen-off.png")}
              alt=""
              onClick={() => {
                this.common.screenShareClick();
              }}
            />
          </div>
          {/*  聊天室页面  */}
          <div id="room-root" className="col-div">
            {/* <div
              className="row-div card"
              style={{
                width: "100%",
                height: "65px",
                justifyContent: "space-between",
              }}
            >
              <!-- 分享屏幕 退出 按钮 -->
              <div
                className="row-div"
                style={{ height: "100%", width: "auto" }}
              >
                <img
                  id="screen-btn"
                  style={{ width: "65px", height: "65px" }}
                  src="./img/screen-off.png"
                  src={require("../../../assets/images/prevention/screen-off.png")}
                  alt=""
                  onClick={() => {
                    this.common.screenShareClick();
                  }}
                />
                <div style="width: 20px"></div>
                <img
                  id="logout-btn"
                  style={{ width: "65px", height: "65px" }}
                  src="./img/logout.png"
                  alt=""
                />
              </div>
              <div
                id="header-roomId"
                style={{
                  width: "230px",
                  justifyContent: "flex-end",
                  paddingRight: "20px",
                  fontSize: "14px",
                  color: "#888888",
                }}
              >
                房间号: 12345
              </div>
            </div> */}
            {/* <!-- content --> */}
            <div
              className="row-div"
              style={{
                height: "100%",
                width: "100%",
                padding: " 10px",
                display: " flex",
                alignItems: "center",
              }}
            >
              <div
                className="col-div"
                style={{
                  width: "340px",
                  height: "100%",
                  padding: "10px",
                  display: "none",
                }}
              >
                <div
                  className="col-div card"
                  style={{ width: "100%", height: "100%" }}
                >
                  {/* <!-- 成员列表 --> */}
                  <div
                    id="member-list"
                    className="col-div"
                    style={{
                      width: "100%",
                      justifyContent: "flex-start",
                      flex: 1,
                    }}
                  >
                    {/* <!-- member --> */}
                    <div
                      id="member-me"
                      style={{ width: "100%", paddingLeft: "20px" }}
                    >
                      <div
                        className="row-div member"
                        style={{
                          width: "100%",
                          height: "50px",
                          justifyContent: "space-between",
                        }}
                      >
                        <div className="member-id">(我)</div>
                        <div
                          className="row-div"
                          style={{
                            width: "100%",
                            height: "27px",
                            justifyContent: "center",
                            display: "flex",
                            alignItems: "center",
                          }}
                        >
                          <img
                            className="member-video-btn"
                            style={{ height: "100%" }}
                            src={require("../../../assets/images/prevention/camera-on.png")}
                            alt=""
                          />
                          <div style={{ width: 18 }}></div>
                          <img
                            className="member-audio-btn"
                            style={{ height: "100%" }}
                            src={require("../../../assets/images/prevention/mic-on.png")}
                            alt=""
                          />
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
              {/* <!-- 视频网格 --> */}
              {/* <div id="video-grid" style={{ height: "100%", flex: 1 }}> */}
              <div id="remote-video-wrap" style={{ height: "100%", flex: 1 }}>
                {/* <!-- 主视频 --> */}
                <Row style={{ height: "100%" }}>
                  <Col
                    span={18}
                    style={{ paddingRight: "10px", height: "100%" }}
                    id="div-video-local"
                    className=" col-div"
                  >
                    <div
                      id="main-video"
                      style={{
                        justifyContent: "flex-end",
                        position: "relative",
                        marginBottom: "10px",
                      }}
                      onClick={() => this.common.mainVideoClick()}
                    >
                      {/* <!-- 主视频控制按钮 --> */}
                      <div
                        id="main-video-btns"
                        className="row-div"
                        style={{
                          width: "156px",
                          position: "absolute",
                          zIndex: 10,
                          justifyContent: "center",
                          alignSelf: "flex-end",
                          right: "0",
                          bottom: "0",
                        }}
                      >
                        <img
                          id="video-btn"
                          style={{ width: " 68px", height: "68px" }}
                          // onClick="event.cancelBubble = true"
                          onClick={() => {
                            if (this.common.isCamOn) {
                              this.common.isCamOn = false;
                              this.common.muteVideo();
                              this.setState({
                                isCamOn: !this.state.isCamOn,
                              });
                            } else {
                              this.common.isCamOn = true;
                              this.setState({
                                isCamOn: !this.state.isCamOn,
                              });
                              this.common.unmuteVideo();
                            }
                          }}
                          src={
                            this.state.isCamOn
                              ? require("../../../assets/images/prevention/big-camera-on.png")
                              : require("../../../assets/images/prevention/big-camera-off.png")
                          }
                          alt=""
                          title={
                            this.state.isCamOn ? "关闭摄像头" : "打开摄像头"
                          }
                        />
                        <img
                          id="mic-btn"
                          style={{ width: " 68px", height: "68px" }}
                          // onClick="event.cancelBubble = true"
                          onClick={() => {
                            if (this.common.isMicOn) {
                              this.common.isMicOn = false;
                              this.common.muteAudio();
                              this.setState({
                                isMicOn: !this.state.isMicOn,
                              });
                            } else {
                              this.common.isMicOn = true;
                              this.common.unmuteAudio();
                              this.setState({
                                isMicOn: !this.state.isMicOn,
                              });
                            }
                          }}
                          src={
                            this.state.isMicOn
                              ? require("../../../assets/images/prevention/big-mic-on.png")
                              : require("../../../assets/images/prevention/big-mic-off.png")
                          }
                          alt=""
                          title={
                            this.state.isMicOn ? "关闭麦克风" : "打开麦克风"
                          }
                        />
                      </div>
                      <div
                        id="mask_main"
                        className="mask col-div"
                        style={{ display: "none" }}
                      >
                        {/* <!-- “如果摄像头未开启”遮罩 --> */}
                        <div
                          style={{
                            height: "100%",
                            width: "100%",
                            position: "absolute",
                            backgroundColor: "#D8D8D8",
                          }}
                        ></div>
                        <img
                          style={{ width: "63px", height: "69px", zIndex: 10 }}
                          src={require("../../../assets/images/prevention/camera-max.png")}
                          alt=""
                        />
                        <div style={{ height: "10px" }}></div>
                        <div style={{ zIndex: 10 }}>摄像头未打开</div>
                      </div>
                    </div>
                  </Col>
                  <Col
                    span={6}
                    id="div-video-child"
                    style={{
                      // height: this.state.height + 'px',
                      height: "100%",
                      padding: "0 10px 10px 10px",
                      overflowY: "auto",
                      overflowX: "hidden",
                    }}
                  ></Col>
                </Row>
              </div>
            </div>
          </div>
        </div>
      </div>
    );
  }
}
