/**
 * 录制记录列表
 */
import React, { PureComponent } from "react";
import style from "styled-components";
import { connect } from "dva";
import PTable from "../../../components/Pro/PTable";
import { Pagination, Drawer, Tooltip, Modal, Row, Input, Button } from "antd";
import columnFun from "./columns";
import { getVideoRoomDetail } from "../../../services/api";
import RecordDrawer from "./Drawer";
@connect((state) => ({}))
export default class RecordList extends PureComponent {
  constructor(props) {
    super(props);
    this.state = {
      forceUpdate: false,
      pageParm: {
        pageNumber: 1,
        pageSize: 10,
        yardmanTaskName: "",
      },
      yardmanTaskName: "",
      visibleDrawer: false,
      selectComVideoRoomId: "",
    };
  }
  componentDidMount() {
    document.querySelector(".ant-layout-sider").style.display = "none";
    document.querySelector(".ant-layout-content").style.margin = "0px";
    document.querySelector(".oneKeySearchHidden").style.display = "none";
    //隐藏顶部菜单栏
    document.querySelector(".ant-layout-header").style.display = "none";
  }
  //搜索
  search() {
    const { yardmanTaskName } = this.state;
    const pageParm = this.state.pageParm;
    pageParm.yardmanTaskName = yardmanTaskName;
    this.setState(
      {
        pageParm,
        forceUpdate: true,
      },
      () => {
        this.setState({
          forceUpdate: false,
        });
      }
    );
  }
  //重置
  reset() {
    const pageParm = {
      ...this.state.pageParm,
      yardmanTaskName: "",
    };
    this.setState(
      {
        pageParm,
        yardmanTaskName: "",
      },
      () => {
        this.setState({
          forceUpdate: false,
        });
      }
    );
  }
  //获取详情信息
  getDetail() {
    getVideoRoomDetail().then((res) => {
      console.log(res);
    });
  }
  //打开详情信息
  changDetail(comVideoRoomId) {
    this.setState({
      selectComVideoRoomId: comVideoRoomId,
      visibleDrawer: true,
    });
  }
  render() {
    const columns = columnFun.call(this);
    return (
      <Container key="recordList">
        <label>
          名称：
          <Input
            style={{ width: 224, marginBottom: "16px" }}
            placeholder="请输入调度任务名称"
            onChange={(e) => {
              this.setState({
                yardmanTaskName: e.target.value,
              });
            }}
            maxLength={20}
            value={this.state.yardmanTaskName}
          />
        </label>
        <Button
          style={{ marginLeft: 16, marginBottom: "16px" }}
          type="primary"
          onClick={() => this.search()}
        >
          搜索
        </Button>
        <Button
          style={{ marginLeft: 16, marginBottom: "16px" }}
          onClick={() => this.reset()}
        >
          重置
        </Button>
        <PTable
          columns={columns}
          url="findComVideoRoomPage"
          pageParm={this.state.pageParm}
          forceUpdate={this.state.forceUpdate}
        />
        <RecordDrawer
          visibleDrawer={this.state.visibleDrawer}
          comVideoRoomId={this.state.selectComVideoRoomId}
          changeDrawer={(value) => {
            this.setState({
              visibleDrawer: value,
            });
          }}
        />
      </Container>
    );
  }
}

const Container = style.div`
              width:100%;
              height:100%;
              padding:10px 30px
            `;
