/**
 * IM可视化视图
 */
import React, { Component } from 'react';
import { Pagination, Badge, Tooltip, Popover } from 'antd';
import { connect } from 'dva';
import './im.less';
import ConversationList from './ConversationList';
import FriendList from './FriendList';
@connect(state => ({
  totalUnreadCount: state.im.totalUnreadCount
}))
export default class SideBar extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showConversationList: true,
      showFriendList: false,
      conversationID:props.conversationID
    };
  }

  componentDidMount() {}
  componentWillReceiveProps(nextProps) {
    this.setState({
      conversationID: nextProps.conversationID
    });
  }

  render() {
    return (
      <div className="side-bar-wrapper">
        {/* <div className="bar-header">
          <div className="tab-items">
            <Badge count={this.props.totalUnreadCount} showZero={false}>
              <Tooltip placement="rightBottom" title="会话列表">
                <Icon
                  type="message"
                  className="iconfont"
                  onClick={() => {
                    this.setState({
                      showConversationList: true,
                      showFriendList: false
                    });
                  }}
                />
              </Tooltip>
            </Badge>
            <Tooltip placement="rightBottom" title="好友列表">
              <Icon
                type="team"
                className="iconfont"
                onClick={() => {
                  this.setState({
                    showConversationList: false,
                    showFriendList: true
                  });
                }}
              />
            </Tooltip>
          </div>
        </div> */}
        <div className="bar-content">
          <ConversationList
            visible={this.state.showConversationList}
            conversationID={this.state.conversationID}
            // closeClick={() => {
            //   this.props.closeClick();
            // }}
          />
          {/* <group-list v-show="showGroupList" /> */}
          {/* <FriendList visible={this.state.showFriendList} /> */}
        </div>
      </div>
    );
  }
}
