//通讯录
import React, { PureComponent } from "react";
import { Tabs, Tree, Button } from "antd";
import {
  systemComDepartGetDepartTree,
  systemComDepartGetOrgPersonList,
} from "../../../../../../services/api";
import PersonList from './PersonList';
const { TreeNode, DirectoryTree } = Tree;

export default class AddressBook extends PureComponent {
  constructor(props) {
    super(props);
    this.state = {
      departTreeData: null,
      //   editTreeData: null,
      treeData: [],
      expandedKeys: ["-1"],
      tableData: [],
      selectedRows: null,
      selectedRowKeys: null,
      height: null, //搜索列表的最大高度
      pagenav: {
        current: 1,
        pageSize: 10,
        showQuickJumper: true,
        showSizeChanger: true,
        showTotal: (total) => `总共 ${total} 条`,
        onShowSizeChange: (current, pageSize) => {
          const pagenav = Object.assign({}, this.state.pagenav);
          pagenav.current = current;
          pagenav.pageSize = pageSize;
          this.setState({ pagenav }, () => {
            this.__getOrgPersonList(this.state.requestData);
          });
        },
        onChange: (page, pageSize) => {
          const pagenav = Object.assign({}, this.state.pagenav);
          pagenav.current = page;
          pagenav.pageSize = pageSize;
          this.setState({ pagenav }, () => {
            this.__getOrgPersonList(this.state.requestData);
          });
        },
        total: 0,
      },
    };
  }
  componentDidMount() {
    const height = document.documentElement.clientHeight - 120 - 130 - 40;
    this.setState({ height });
    this.__getDepartTree();
  }
  __getDepartTree(cb) {
    // 获取到组织架构列表
    systemComDepartGetDepartTree().then((res) => {
      // 初始化页面判断右边列表的展示
      if (res.data[0] && res.data[0].isExistsDataAuth == 0) {
        this.setState({
          rightListShow: true,
        });
      }
      this.setState(
        {
          departTreeData: this.recursionTreeData(res.data, true), //含有disable属性
          // editTreeData: this.recursionTreeData(res.data, true),
          treeData: this.recursionTreeData(res.data),
        },
        () => {
          cb && cb(res.data);
        }
      );
    });
  }
  recursionTreeData(treeData, hasDisable) {
    treeData = JSON.parse(JSON.stringify(treeData));
    // TreeSelect组件所需值： title， value, key, children disabled
    return treeData.map((item) => {
      item.title = item.departName;
      item.key = item.departId;
      item.value = item.departId;

      if (hasDisable) {
        // "isExistsDataAuth": "1",  //权限 1有权限 0：没权限
        item.disabled = item.isExistsDataAuth == 0;
      } else {
        // 没有权限的部门名称后面新增人数
        item.title = `${item.departName}(${item.personCount})`;
      }
      // 不展示下级部门
      // if(idArr.some(id => id == item.departId)) return item;
      if (item.childDepart) {
        item.children = this.recursionTreeData(item.childDepart, hasDisable);
      }
      return item;
    });
  }
  __getOrgPersonList(data) {
    const POST_DATA = {
      pageSize: this.state.pagenav.pageSize,
      pageNumber: this.state.pagenav.current,
      ...data,
    };
    systemComDepartGetOrgPersonList(POST_DATA).then((response) => {
      const { pageNumber, pageSize } = response.data;
      const tableData = response.data.data.map((val, i) => {
        val.key = i;
        val.number = (pageNumber - 1) * pageSize + i + 1;
        return val;
      });
      const pagenav = Object.assign({}, this.state.pagenav);
      pagenav.total = response.data.total;
      this.setState({
        tableData,
        selectedRows: [],
        selectedRowKeys: [],
        pagenav,
      });
    });
  }
  // 递归展示树状组织架构
  renderTreeNodes = (data, parentkey, parentTitle) => {
    return data.map((item, index) => (
      <TreeNode
        departId={item.departId}
        isExistsDataAuth={item.isExistsDataAuth}
        key={`${parentkey}-${index}`}
        title={`${item.departName}(${item.personCount})`}
      >
        {
          (() => {
            if (item.childDepart.length > 0) {
              parentkey++;
              return this.renderTreeNodes(item.childDepart, parentkey);
            }
          })()
        }
      </TreeNode>)
    );
  };
  render() {
    return (
      <div className='PartmentSelect'>
        <div className="data-list address-book PartmentSelect-box">
          <PersonList
            style={{ maxHeight: this.state.height,overflow:'auto' }}
            // fetchType={this.props.fetchType}
            type='radio'
            value={[]}
            //点击调度
            clickTextScheduling={(item, type) => {
              this.props.clickTextScheduling(item, type);
            }}
          />
        </div>
      </div>);
  }
}
