import React, { Component } from "react";
import { connect } from "dva";
import moment from "moment";
import {
  Form,
  Input,
  Select,
  Col,
  Timeline,
  Row,
  Button,
  Radio,
  Steps,
  Checkbox,
  Icon,
  Table,
  InputNumber,
  TimePicker,
  Modal
} from "antd";
import Drawer from "react-motion-drawer";

import {
  taskAttendanceComattendgroupfixedSave, //新增内勤组-选择考勤类型-固定班制-新增
  taskAttendanceComattendgroupfixedGetAddTemp, //新增内勤组-选择考勤类型-固定班制-获取周一到周日模板
  taskAttendanceComattendgroupfixedUpdate, //新增内勤组-选择考勤类型-固定班制-修改
  taskAttendanceComattendgroupfixedGetDetail, //新增内勤组-选择考勤类型-固定班制-详情
  taskComShiftPage //获取班次分页查询
} from "../../services/api";

import "./ThiftManagement.less";

const FormItem = Form.Item;
const { Option } = Select;
const { Step } = Steps;
const format = "HH:mm";

const formItemLayout = {
  labelCol: {
    xs: { span: 24 },
    sm: { span: 7 }
  },
  wrapperCol: {
    xs: { span: 24 },
    sm: { span: 12 },
    md: { span: 10 }
  }
};

const submitFormLayout = {
  wrapperCol: {
    xs: { span: 24, offset: 0 },
    sm: { span: 10, offset: 7 }
  }
};
const formItemLayout1 = {
  labelCol: {
    xs: { span: 24 },
    sm: { span: 6 }
  },
  wrapperCol: {
    xs: { span: 24 },
    sm: { span: 18 },
    md: { span: 16 }
  }
};

const formItemLayout2 = {
  labelCol: {
    xs: { span: 24 },
    sm: { span: 3 }
  },
  wrapperCol: {
    xs: { span: 24 },
    sm: { span: 21 },
    md: { span: 21 }
  }
};

/*
固定班制---设置出勤班次 */
const columns1 = [
  {
    title: "工作日",
    dataIndex: "workday",
    key: "2"
  },
  {
    title: "班次详情",
    dataIndex: "detail",
    key: "3"
  },
  {
    title: "操作",
    dataIndex: "option",
    key: "4",
    render: text => {
      return <div style={{ color: "rgba(15,113,255,1)" }}>{text}</div>;
    }
  }
];
const dataSource1 = [
  {
    key: "1",
    workday: "周一",
    detail: "休息",
    option: "选择班次"
  },
  {
    key: "2",
    workday: "周二",
    detail: "休息",
    option: "选择班次"
  },
  {
    key: "3",
    workday: "周三",
    detail: "休息",
    option: "选择班次"
  },
  {
    key: "4",
    workday: "周四",
    detail: "休息",
    option: "选择班次"
  },
  {
    key: "5",
    workday: "周五",
    detail: "休息",
    option: "选择班次"
  },
  {
    key: "6",
    workday: "周六",
    detail: "休息",
    option: "选择班次"
  },
  {
    key: "7",
    workday: "周日",
    detail: "休息",
    option: "选择班次"
  }
];

/* 排班制----设置出勤班次 */
const columns2 = [
  {
    title: "列号",
    dataIndex: "list",
    key: "1"
  },
  {
    title: "班次名称",
    dataIndex: "banci",
    key: "2"
  },
  {
    title: "时间安排",
    dataIndex: "time",
    key: "3",
    render: text => {
      return <div style={{ color: "rgba(15,113,255,1)" }}>{text}</div>;
    }
  }
];
const dataSource2 = [
  {
    key: "1",
    banci: "班次A",
    time: "09:00-12:00"
  },
  {
    key: "2",
    banci: "一天3班3个次日班",
    time: "09:00-11:00 | 12:00 -14:00 | 15:00-18:00"
  }
];

/* 排班制----周期性排班设置 */
const columns3 = [
  {
    title: "",
    dataIndex: "a",
    key: "1"
  },
  {
    title: "周期名称",
    dataIndex: "b",
    key: "1"
  },
  {
    title: "周期天数",
    dataIndex: "c",
    key: "2"
  },
  {
    title: "启用班次",
    dataIndex: "d",
    key: "3",
    render: text => {
      return <div style={{ color: "rgba(15,113,255,1)" }}>{text}</div>;
    }
  },
  {
    title: "操作",
    dataIndex: "e",
    key: "4",
    render: () => {
      return <div style={{ color: "rgba(15,113,255,1)" }}>修改</div>;
    }
  }
];
const dataSource3 = [
  {
    a: "1",
    b: "1",
    c: "班次A",
    d: "09:00-12:00",
    e: "09:00-12:00"
  }
];

/* 选择班次--drawer */
const columns4 = [
  {
    title: "班次名称",
    dataIndex: "bc",
    render: text => <a href="#">{text}</a>
  },
  {
    title: "出勤时间",
    dataIndex: "time"
  }
];
const dataSource4 = [
  {
    key: "1",
    bc: "John Brown",
    time: 32
  },
  {
    key: "2",
    bc: "John Brown",
    time: 32
  },
  {
    key: "3",
    bc: "John Brown",
    time: 32
  }
];

const rowSelection = {
  onChange: (selectedRowKeys, selectedRows) => {
    // console.log(
    //   `selectedRowKeys: ${selectedRowKeys}`,
    //   "selectedRows: ",
    //   selectedRows
    // );
  },
  getCheckboxProps: record => ({
    disabled: record.name === "Disabled User" // Column configuration not to be checked
  })
};

const rowSelectionRadio = {
  type: "radio",
  onChange: (selectedRowKeys, selectedRows) => {
    // console.log(
    //   `selectedRowKeys: ${selectedRowKeys}`,
    //   "selectedRows: ",
    //   selectedRows
    // );
  },
  getCheckboxProps: record => ({
    disabled: record.name === "Disabled User" // Column configuration not to be checked
  })
};

@connect(state => ({
  profile: state.profile
}))
@Form.create()
export default class SelectionAttendanceType extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      open: false, //固定--添加班次
      open1: false, //排班次--添加班次
      selectedTags: [],
      pagenav: {
        current: 1,
        pageSize: 10,
        showQuickJumper: true,
        showSizeChanger: true,
        showTotal: total => `总共 ${total} 条`,
        onShowSizeChange: (current, pageSize) => {
          const pagenav = Object.assign({}, this.state.pagenav);
          pagenav.current = current;
          pagenav.pageSize = pageSize;
          this.setState({ pagenav });
          setTimeout(() => {
            this.bbdExampersonPage();
          });
        },
        onChange: (page, pageSize) => {
          const pagenav = Object.assign({}, this.state.pagenav);
          pagenav.current = page;
          pagenav.pageSize = pageSize;
          this.setState({ pagenav });
          setTimeout(() => {
            this.bbdExampersonPage();
          });
        },
        total: 0
      }
    };

  }

  componentDidMount() {
    // window.initialize = this.initializeMap;
    this.loadMapScript();
    taskAttendanceComattendgroupfixedGetDetail({}).then(data => {
      console.log(data, "componentDidMount");
    });
  }

  initializeMap = () => {
    const that = this;
    const { BMap } = window;
    const map = new BMap.Map("taskMapContainer");
    map.centerAndZoom(new BMap.Point(116.404, 39.915), 12);
    map.addControl(new BMap.NavigationControl());
    const ac = new BMap.Autocomplete({
      input: "suggestId",
      location: map
    });
    function myFun(result) {
      const cityName = result.name;
      map.setCenter(cityName);
    }
    const myCity = new BMap.LocalCity();
    myCity.get(myFun);

    ac.addEventListener("onhighlight", function a(e) {
      //鼠标放在下拉列表上的事件
      console.log(e);
    });

    let myValue;
    ac.addEventListener("onconfirm", function a(e) {
      //鼠标点击下拉列表后的事件
      const value1 = e.item.value;
      myValue =
        value1.province +
        value1.city +
        value1.district +
        value1.street +
        value1.business;
      setPlace();
    });

    function setPlace() {
      map.clearOverlays(); //清除地图上所有覆盖物
      function myFun1() {
        const pp = local.getResults().getPoi(0).point; //获取第一个智能搜索的结果
        map.centerAndZoom(pp, 18);
        map.addOverlay(new BMap.Marker(pp)); //添加标注
      }
      const local = new BMap.LocalSearch(map, {
        //智能搜索
        onSearchComplete: myFun1,
        renderOptions: { map }
      });
      that.setState({ address: myValue });
      local.search(myValue);
    }
  };

  loadMapScript = () => {
    const script = document.createElement("script");
    script.src =
      "http://api.map.baidu.com/api?v=2.0&ak=B3RiZN5ZwDWnFLlzYUlY0G9ety0jiqHr&callback=initialize";
    document.body.appendChild(script);
  };
  handleSubmit = e => {
    e.preventDefault();
    this.props.form.validateFieldsAndScroll((err, values) => {
      if (!err) {
        this.props.dispatch({
          type: "form/submitRegularForm",
          payload: values
        });
      }
    });
  };
  callback = key => {
    console.log(key);
  };

  handleOk = e => {
    this.setState({
      visible: false
    });
  };
  handleCancel = e => {
    this.setState({
      visible: false
    });
  };

  handleChange(tag, checked) {
    const { selectedTags } = this.state;
    const nextSelectedTags = checked
      ? [...selectedTags, tag]
      : selectedTags.filter(t => t !== tag);
    this.setState({ selectedTags: nextSelectedTags });
  }

  /* 验证手机号码 */
  checkPhone = (rule, value, callback) => {
    if (value && !/^1[0-9]{10}$/.test(value)) {
      callback("请输入正确的手机号码！");
    } else {
      callback();
    }
  };

  /* 固定上班次 */
  fixedShiftRender = () => {
    const { getFieldDecorator } = this.props.form;
    return (
      <FormItem {...formItemLayout} label="工作安排">
        {getFieldDecorator("branch", {
          rules: [
            {
              required: true,
              message: "请选择"
            }
          ]
        })(
          <div>
            <Button
              onClick={() => {
                this.setState({ open: true });
              }}
              style={{ marginBottom: 16 }}
              type="primary"
              ghost
            >
              选择默认班次
            </Button>
            <div className="hadSelectDefault">
              <em>已选默认班次：</em>班次A(09:00-18:00){" "}
              <span
                onClick={() => {
                  this.setState({ open: true });
                }}
              >
                更换默认班次
              </span>
            </div>
            <Table
              size="middle"
              rowSelection={rowSelection}
              pagination={false}
              columns={columns1}
              dataSource={dataSource1}
            />
          </div>
        )}
      </FormItem>
    );
  };

  /* 排班制--出勤班次 */
  scheduleRender = () => {
    const { getFieldDecorator } = this.props.form;

    return (
      <FormItem {...formItemLayout} label="设置排班班次">
        {getFieldDecorator("branch", {
          rules: [
            {
              required: true,
              message: "请选择"
            }
          ]
        })(
          <div>
            <Button
              onClick={() => {
                this.setState({ open1: true });
              }}
              style={{ marginBottom: 16 }}
              type="primary"
              ghost
            >
              添加班次
            </Button>
            <Table
              size="middle"
              pagination={false}
              columns={columns2}
              dataSource={dataSource2}
            />
          </div>
        )}
      </FormItem>
    );
  };

  /* 排班制--周期性排班 */
  periodicityRender = () => {
    const { getFieldDecorator } = this.props.form;
    return (
      <FormItem {...formItemLayout} label="周期性排班设置">
        {getFieldDecorator("branch", {
          rules: [
            {
              required: true,
              message: "请选择"
            }
          ]
        })(
          <div>
            <Button
              onClick={() => {
                this.setState({ open2: true });
              }}
              style={{ marginBottom: 16 }}
              type="primary"
              ghost
            >
              添加周期
            </Button>
            <Table
              size="middle"
              pagination={false}
              columns={columns3}
              dataSource={dataSource3}
            />
          </div>
        )}
      </FormItem>
    );
  };

  render() {
    const { submitting } = this.props;
    const { getFieldDecorator } = this.props.form;
    return (
      <div className="CreateTask ThiftManagement">
        <div className="card">选择考勤类型</div>
        <div className="Steps">
          <Steps current={1}>
            <Step title="设置考勤人员" />
            <Step title="选择考勤类型" />
            <Step title="考勤方式" />
            <Step title="完成" />
          </Steps>
        </div>
        <Form onSubmit={this.handleSubmit} style={{ marginTop: 24 }}>
          <FormItem {...formItemLayout} label="选择出勤类型">
            {getFieldDecorator("branch", {
              initialvalue: this.state,
              rules: [
                {
                  required: true,
                  message: "请选择"
                }
              ]
            })(
              <Radio.Group>
                <Radio className="radioStyle" value="1">
                  固定班制（每周考勤模式一致）{" "}
                  <span className="exclamation">
                    <Icon type="exclamation-circle" />适用于每周考勤固定的团队和部门。
                  </span>
                </Radio>
                {/*   <Radio className="radioStyle" value="1">排班制（自定义设置考勤时间）<span className="exclamation"><Icon type="exclamation-circle" />适用于需要灵活排班，轮流上岗的团队和部门。</span></Radio>
                <Radio className="radioStyle" value="1">自由工时（不设置班次，可随时打卡计算工时）<span className="exclamation"><Icon type="exclamation-circle" />适用于根据工作时长计算报酬的团和部门。</span></Radio> */}
              </Radio.Group>
            )}
          </FormItem>
          {/* 固定班次 */}
          {this.fixedShiftRender()}
          {/* 排班次--出勤班次 */}
          {/* this.scheduleRender() */}
          {/* 排班次--周期性排班 */}
          {/* this.periodicityRender() */}
          {/*  <FormItem
            {...formItemLayout}
            label="设置工作日"
          >
            {getFieldDecorator('branch', {
              rules: [{
                required: true, message: '请选择',
              }],
            })(
              <Checkbox.Group className="checkbox-group">
                <Row>
                  <Col span={3}><Checkbox value="A">周一</Checkbox></Col>
                  <Col span={3}><Checkbox value="B">周二</Checkbox></Col>
                  <Col span={3}><Checkbox value="C">周三</Checkbox></Col>
                  <Col span={3}><Checkbox value="D">周四</Checkbox></Col>
                  <Col span={3}><Checkbox value="E">周五</Checkbox></Col>
                  <Col span={3}><Checkbox value="E">周六</Checkbox></Col>
                  <Col span={3}><Checkbox value="E">周日</Checkbox></Col>
                </Row>
              </Checkbox.Group>,
            )}
          </FormItem>
          <FormItem
            {...formItemLayout}
            label="设置出勤起点"
          >
            {getFieldDecorator('company', {
              rules: [{
                required: true, message: '请输入',
              }],
            })(
              <Row>
                <Col span={12}>
                  <TimePicker placeholder="请选择考勤时间(设置时间不得超过23:59)" style={{ width: "100%" }} />
                </Col>
                <Col span={12}>
                  <span className="exclamation"><Icon type="exclamation-circle" />达到考勤起点时间之后才可以打卡并计算工时</span>
                </Col>
              </Row>
              )}
          </FormItem> */}
          <FormItem {...submitFormLayout} style={{ marginTop: 24 }}>
            <Button loading={submitting}>返回</Button>
            <Button type="primary" style={{ marginLeft: 8 }} htmlType="submit">
              确认并进行下一步
            </Button>
          </FormItem>
        </Form>
        {/* 固定班次--选择班次*/}
        <Drawer
          overlayColor="rgba(0, 0, 0,0)"
          right
          open={this.state.open}
          noTouchClose
          width={600}
          className="drawer-box"
          onChange={open => {
            this.setState({ open });
          }}
        >
          <div className="drawer">
            <div className="drawer-header">
              选择默认班次{" "}
              {/* <Button type="primary" onClick={() => this.setState({ open3: true, open: false })} ghost>新增班次</Button> */}
            </div>
            <div className="drawer-content">
              <Table
                pagination={false}
                rowSelection={rowSelectionRadio}
                columns={columns4}
                dataSource={dataSource4}
              />
            </div>
            <div className="drawer-footer">
              <Button>取消</Button>
              <Button type="primary">确定</Button>
            </div>
          </div>
        </Drawer>
        {/*  排班次--添加班次 */}
        <Drawer
          overlayColor="rgba(0, 0, 0,0)"
          right
          open={this.state.open1}
          noTouchClose
          width={600}
          className="drawer-box"
          onChange={open1 => {
            this.setState({ open1 });
          }}
        >
          <div className="drawer">
            <div className="drawer-header">
              添加班次{" "}
              {/* <Button onClick={() => this.setState({ open3: true, open1: false })} type="primary" ghost>新增班次</Button> */}
            </div>
            <div className="drawer-content">
              <Table
                pagination={false}
                rowSelection={rowSelectionRadio}
                columns={columns4}
                dataSource={dataSource4}
              />
            </div>
            <div className="drawer-footer">
              <Button>取消</Button>
              <Button type="primary">确定</Button>
            </div>
          </div>
        </Drawer>

        {/*  排班次--添加排班周期 */}
        {/* <Drawer
          overlayColor="rgba(0, 0, 0,0)"
          right
          open={this.state.open2}
          noTouchClose
          width={600}
          className="drawer-box"
          onChange={open2 => {
            this.setState({ open2 });
          }}
        >
          <div className="drawer">
            <div className="drawer-header">添加排班周期</div>
            <div className="drawer-content">
              <Form onSubmit={this.handleSubmit} style={{ marginTop: 24 }}>
                <FormItem {...formItemLayout} label="周期名称">
                  {getFieldDecorator("address", {
                    rules: [{ required: true, message: "请输入" }]
                  })(<Input />)}
                </FormItem>
                <FormItem
                  {...formItemLayout}
                  label="周期天数"
                  help={
                    <div style={{ color: "#87D068" }}>
                      2天为一周期进行循环排班
                    </div>
                  }
                >
                  {getFieldDecorator("address", {
                    rules: [{ required: true, message: "请输入" }]
                  })(<Input addonAfter="天" />)}
                </FormItem>
                <FormItem
                  {...formItemLayout}
                  label="第一天班次"
                  help={
                    <div>
                      09:00-18:00 | 18:00-06:00<span
                        style={{ color: "#F5222E" }}
                      >
                        次日
                      </span>
                    </div>
                  }
                >
                  {getFieldDecorator("address", {
                    rules: [{ required: true, message: "请输入" }]
                  })(
                    <Select
                      placeholder="Select a person"
                      optionFilterProp="children"
                      filterOption={(input, option) =>
                        option.props.children
                          .toLowerCase()
                          .indexOf(input.toLowerCase()) >= 0
                      }
                    >
                      <Option value="jack">Jack</Option>
                      <Option value="lucy">Lucy</Option>
                      <Option value="tom">Tom</Option>
                    </Select>
                  )}
                </FormItem>
                <FormItem {...formItemLayout} label="第二天班次">
                  {getFieldDecorator("address", {
                    rules: [{ required: true, message: "请输入" }]
                  })(
                    <Select
                      placeholder="Select a person"
                      optionFilterProp="children"
                      filterOption={(input, option) =>
                        option.props.children
                          .toLowerCase()
                          .indexOf(input.toLowerCase()) >= 0
                      }
                    >
                      <Option value="jack">Jack</Option>
                      <Option value="lucy">Lucy</Option>
                      <Option value="tom">Tom</Option>
                    </Select>
                  )}
                </FormItem>
              </Form>
            </div>
            <div className="drawer-footer">
              <Button>取消</Button>
              <Button type="primary">确定</Button>
            </div>
          </div>
        </Drawer> */}

        {/*  选择班次--新增班次 */}
        {/* <Drawer
          overlayColor="rgba(0, 0, 0,0)"
          right
          open={this.state.open3}
          noTouchClose
          width={600}
          className="drawer-box"
          zIndex={2}
          onChange={open3 => {
            this.setState({ open3 });
          }}
        >
          <div className="drawer task-drawer">
            <div className="drawer-header">新增班次</div>
            <div className="drawer-content">
              <Form onSubmit={this.handleSubmit} style={{ marginTop: 24 }}>
                <FormItem {...formItemLayout} label="班次名称">
                  {getFieldDecorator("address", {
                    rules: [{ required: true, message: "请输入" }]
                  })(<Input />)}
                </FormItem>
                <FormItem {...formItemLayout} label="一天上下班冷饮数">
                  {getFieldDecorator("address", {
                    rules: [{ required: true, message: "请输入" }]
                  })(<Input addonAfter="次" />)}
                </FormItem>
                <FormItem
                  {...formItemLayout}
                  label="第一轮班次"
                  style={{ marginBottom: 0 }}
                >
                  {getFieldDecorator("address", {
                    rules: [{ required: true, message: "请输入" }]
                  })(
                    <Timeline>
                      <Timeline.Item color="green">
                        上班：<TimePicker
                          className="task-TimePicker"
                          defaultValue={moment("12:08", format)}
                          format={format}
                        />
                      </Timeline.Item>
                      <Timeline.Item color="orange">
                        下班：<TimePicker
                          className="task-TimePicker"
                          defaultValue={moment("12:08", format)}
                          format={format}
                        />
                      </Timeline.Item>
                    </Timeline>
                  )}
                </FormItem>
                <FormItem
                  {...formItemLayout}
                  style={{ marginBottom: 0 }}
                  label="第二轮班次"
                >
                  {getFieldDecorator("address", {
                    rules: [{ required: true, message: "请输入" }]
                  })(
                    <Timeline>
                      <Timeline.Item color="green">
                        上班：<TimePicker
                          className="task-TimePicker"
                          defaultValue={moment("12:08", format)}
                          format={format}
                        />
                      </Timeline.Item>
                      <Timeline.Item color="orange">
                        下班：<TimePicker
                          className="task-TimePicker"
                          defaultValue={moment("12:08", format)}
                          format={format}
                        />
                      </Timeline.Item>
                    </Timeline>
                  )}
                </FormItem>
                <FormItem
                  {...formItemLayout}
                  style={{ marginBottom: 0 }}
                  label="第三轮班次"
                  help={
                    <div className="help">
                      合计工作时长<span>21</span>小时<span>00</span>
                    </div>
                  }
                >
                  {getFieldDecorator("address", {
                    rules: [{ required: true, message: "请输入" }]
                  })(
                    <Timeline style={{ marginBottom: 0 }}>
                      <Timeline.Item color="green">
                        上班：<TimePicker
                          className="task-TimePicker"
                          defaultValue={moment("12:08", format)}
                          format={format}
                        />
                      </Timeline.Item>
                      <Timeline.Item color="orange">
                        下班：<TimePicker
                          className="task-TimePicker"
                          defaultValue={moment("12:08", format)}
                          format={format}
                        />
                        <span
                          style={{
                            position: "absolute",
                            right: 0,
                            top: 4,
                            marginRight: -40,
                            color: "#F5222E"
                          }}
                        >
                          次日
                        </span>
                      </Timeline.Item>
                    </Timeline>
                  )}
                </FormItem>
                <div
                  style={{ borderBottom: "1px solid#E9E9E9", margin: "24px" }}
                />
                <FormItem
                  {...{
                    labelCol: {
                      xs: { span: 24 },
                      sm: { span: 7 }
                    },
                    wrapperCol: {
                      xs: { span: 24 },
                      sm: { span: 12 },
                      md: { span: 16 }
                    }
                  }}
                  label="附加设置"
                >
                  {getFieldDecorator("address", {
                    rules: [{ required: true, message: "请输入" }]
                  })(
                    <Checkbox.Group
                      onChange={e => {
                        console.log(e);
                      }}
                    >
                      <Row style={{ marginBottom: 24 }}>
                        {" "}
                        <Checkbox value="A">允许迟到</Checkbox>
                        <InputNumber
                          style={{ width: 88 }}
                          min={1}
                          max={10}
                          defaultValue={3}
                        />分钟
                      </Row>
                      <Row style={{ marginBottom: 24 }}>
                        {" "}
                        <Checkbox value="A">迟到超过</Checkbox>
                        <InputNumber
                          style={{ width: 88 }}
                          min={1}
                          max={10}
                          defaultValue={3}
                        />分钟{" "}
                        <span style={{ color: "#FFAA00" }}>(视为严重迟到)</span>
                      </Row>
                      <Row style={{ marginBottom: 24 }}>
                        {" "}
                        <Checkbox value="A">迟到超过</Checkbox>
                        <InputNumber
                          style={{ width: 88 }}
                          min={1}
                          max={10}
                          defaultValue={3}
                        />分钟<span style={{ color: "#F5222E" }}>
                          (视为旷工)
                        </span>
                      </Row>
                    </Checkbox.Group>
                  )}
                </FormItem>
              </Form>
            </div>
            <div className="drawer-footer">
              <Button>取消</Button>
              <Button type="primary">确定</Button>
            </div>
          </div>
        </Drawer> */}

        {/* <Modal
          title="添加地点"
          visible={this.state.visible}
          okText="提交"
          cancelText="关闭"
          onOk={this.handleOk}
          onCancel={this.handleCancel}
          width={700}
        >
          <div id="taskMapContainer" />
          <Form onSubmit={this.handleSubmit}>
            <FormItem label="地址名称" {...formItemLayout2}>
              <Input id="suggestId" />
            </FormItem>
            <FormItem {...formItemLayout2} label="详细地址">
              {this.state.address}
            </FormItem>
          </Form>
        </Modal> */}

        {/*  <Modal
          title="添加出勤WIFI"
          visible={this.state.visible1}
          okText="确认"
          cancelText="取消"
          onOk={this.handleOk}
          onCancel={this.handleCancel}
        >
          <Form onSubmit={this.handleSubmit}>
            <FormItem label="WIFI名称" {...formItemLayout1}>
              {getFieldDecorator("address", {
                rules: [{ required: true, message: "请输入" }]
              })(<Input />)}
            </FormItem>
            <FormItem {...formItemLayout1} label="MAC地址">
              {getFieldDecorator("address", {
                rules: [{ required: true, message: "请输入" }]
              })(<Input />)}
            </FormItem>
          </Form>
        </Modal> */}
      </div>
    );
  }
}
