import React, { Component } from 'react';
import moment from 'moment';
import {
  Form, Input, Steps, Badge, Button, Table, DatePicker, Popover, Tabs, Checkbox
} from 'antd';
import LetterElment from "../../components/LetterElment";

import './ThiftManagement.less';

const { Step } = Steps;
const FormItem = Form.Item;
const { TabPane } = Tabs;
const { MonthPicker } = DatePicker;
const CheckboxGroup = Checkbox.Group;


const options = [
  { label: <LetterElment name="a" />, value: 'Apple' },
  { label: <LetterElment name="b" />, value: 'Pear' },
  { label: <LetterElment name="c" />, value: 'Orange' },
  { label: <LetterElment name="d" />, value: 'xiu' },
];
const columns = [{
  title: '姓名',
  dataIndex: 'a',
  key: '1',
  width: 80,
  fixed: 'left',
}, {
  title: '10',
  dataIndex: 'b',
  key: '2',
  render: () => {
    const content = (
      <Tabs className="popover-paibang" defaultActiveKey="1">
        <TabPane tab="排班" key="1">
          <CheckboxGroup options={options} />
        </TabPane>
        <TabPane tab="周期排班" key="2">Content of Tab Pane 2</TabPane>
      </Tabs>
    );
    return (
      <Popover content={content} trigger="click">
        <div className="paneltablecolor-list">
          <LetterElment name="a" type="tag" />
          <LetterElment name="b" type="tag" />
          <LetterElment name="c" type="tag" />
          <LetterElment name="d" type="tag" />
          <LetterElment name="xiu" type="tag" />
        </div>
      </Popover>);
  }
}, {
  title: '11',
  dataIndex: 'c',
  key: '3',
  render: () => {
    const content = (
      <Tabs defaultActiveKey="1">
        <TabPane tab="排班" key="1">Content of Tab Pane 1</TabPane>
        <TabPane tab="周期排班" key="2">Content of Tab Pane 2</TabPane>
      </Tabs>
    );
    return (<Popover content={content} trigger="click">
      <div className="paneltablecolor-list">
        <span className="color-orange">A</span>
        <span className="color-green">B</span>
        <span className="color-cyan">C</span>
      </div>
    </Popover>);
  }
}, {
  title: '12',
  dataIndex: 'd',
  key: '4',
  render: () => {
    return (<div className="paneltablecolor-list">
      <span className="color-blue">休</span>
    </div>);
  }
}, {
  title: '13',
  dataIndex: 'e',
  key: '5',
  render: () => {
    return (
      <div className="paneltablecolor-list">
        <span className="color-orange">A</span>
        <span className="color-green">B</span>
        <span className="color-cyan">C</span>
      </div>);
  }
}, {
  title: '14',
  dataIndex: 'f',
  key: '6',
  render: () => {
    return (<div className="paneltablecolor-list">
      <span className="color-orange">A</span>
      <span className="color-green">B</span>
      <span className="color-cyan">C</span>
    </div>);
  }
}, {
  title: '操作',
  dataIndex: 'g',
  key: '7',
  render: () => {
    return (<div style={{ color: "#0E6BF2" }}>重置</div>);
  }
}];

const dataSource = [{
  key: "1",
  a: '1',
  b: '胡彦斌',
  c: 32,
  d: '西湖区湖底公园1号',
  e: '西湖区湖底公园1号',
  f: '西湖区湖底公园1号',
  g: '西湖区湖底公园1号',
}];

@Form.create()
export default class ScheduleSetting extends Component {
  state = {
    pagenav: {
      current: 1,
      pageSize: 10,
      showQuickJumper: true,
      showSizeChanger: true,
      showTotal: total => `总共 ${total} 条`,
      onShowSizeChange: (current, pageSize) => {
        const pagenav = Object.assign({}, this.state.pagenav);
        pagenav.current = current;
        pagenav.pageSize = pageSize;
        this.setState({ pagenav });
        setTimeout(() => {
          this.bbdExampersonPage();
        });
      },
      onChange: (page, pageSize) => {
        const pagenav = Object.assign({}, this.state.pagenav);
        pagenav.current = page;
        pagenav.pageSize = pageSize;
        this.setState({ pagenav });
        setTimeout(() => {
          this.bbdExampersonPage();
        });
      },
      total: 0,
    }
  }
  componentDidMount() {
    /* const { dispatch } = this.props;
    dispatch({
      type: 'profile/fetchBasic',
    }); */
  }



  getListData = (value) => {
    let listData;
    switch (value.date()) {
      case 8:
        listData = [
          { type: 'warning', content: 'This is warning event.' },
          { type: 'success', content: 'This is usual event.' },
        ]; break;
      case 10:
        listData = [
          { type: 'warning', content: 'This is warning event.' },
          { type: 'success', content: 'This is usual event.' },
          { type: 'error', content: 'This is error event.' },
        ]; break;
      case 15:
        listData = [
          { type: 'warning', content: 'This is warning event' },
          { type: 'success', content: 'This is very long usual event。。....' },
          { type: 'error', content: 'This is error event 1.' },
          { type: 'error', content: 'This is error event 2.' },
          { type: 'error', content: 'This is error event 3.' },
          { type: 'error', content: 'This is error event 4.' },
        ]; break;
      default:
    }
    return listData || [];
  }

  getMonthData = (value) => {
    if (value.month() === 8) {
      return 1394;
    }
  }

  monthCellRender = (value) => {
    const num = this.getMonthData(value);
    return num ? (
      <div className="notes-month">
        <section>{num}</section>
        <span>Backlog number</span>
      </div>
    ) : null;
  }

  dateCellRender = (value) => {
    const listData = this.getListData(value);
    return (
      <ul className="events">
        {
          listData.map(item => (
            <li key={item.content}>
              <Badge status={item.type} text={item.content} />
            </li>
          ))
        }
      </ul>
    );
  }


  handleSubmit = (e) => {
    e.preventDefault();
    this.props.form.validateFieldsAndScroll((err, values) => {
      if (!err) {
        this.props.dispatch({
          type: 'form/submitRegularForm',
          payload: values,
        });
      }
    });
  };
  /* 列表模式 */
  renderListPanel = () => {
    return (<Table pagination={this.state.pagenav} bordered dataSource={dataSource} columns={columns} scroll={{ x: 2300 }} />);
  }

  render() {

    const { getFieldDecorator } = this.props.form;

    return (
      <div className="TaskDetail TaskDetailPersonnelPlacement ThiftManagement">
        <div className="card">排班设置</div>
        <div className="Steps">
          <Steps current={2}>
            <Step title="设置考勤人员" />
            <Step title="选择考勤类型" />
            <Step title="考勤地点" />
            <Step title="完成" />
          </Steps>
        </div>
        <div className="info">
          <div className="list">
            <span className="label">班次：</span>
            <LetterElment name="a" />
            <LetterElment name="b" />
            <LetterElment name="c" />
            <LetterElment name="d" />
            <LetterElment name="xiu" />
          </div>
          <div className="list zlist">
            <span className="label">排班周期：</span>
            <div className="item b-color-orange">周期：<em>3天 A-B-C-体</em></div>
            <div className="item b-color-green">班次轮换:A-B-C-休<em>3天</em></div>
          </div>
        </div>

        <div className="form">
          <Form
            onSubmit={this.handleSubmit}
            layout="inline"
          >
            <FormItem
              label="排班月度"
            >
              {getFieldDecorator('address', {
                initialValue: moment('2015-06', 'YYYY-MM'),
                rules: [{ message: '请选择' }],
              })(
                <MonthPicker />
                )}
            </FormItem>
            <FormItem>
              {getFieldDecorator('address', {
                rules: [{ message: '请输入搜索内容' }],
              })(
                <Input
                  placeholder="请输入姓名"
                  style={{ width: 200 }}
                />
                )}
            </FormItem>
            <FormItem
            >
              <Button type="primary">搜索</Button>
            </FormItem>
          </Form>
          {this.renderListPanel()}
        </div>
      </div>
    );
  }
}

