import React, { Component } from 'react';
import { connect } from 'dva';
import { Form, Button, Icon, Table, Modal, Tabs, Alert } from 'antd';
import AddNewAttendanceUnit from './AddNewAttendanceUnit';
import './ThiftManagement.less';
import {
  taskAttendanceComAttendGroupPageForGroup, //获取内勤组分页查询
  taskAttendanceComAttendGroupDelete //删除内勤组
} from '../../services/api';

const { confirm } = Modal;
const { TabPane } = Tabs;

@connect(state => ({
  profile: state.profile
}))
@Form.create()
export default class NewAttendanceUnit extends Component {
  state = {
    open: false, //新增班次
    visible: false, //添加地点
    dataSource: [],
    pagenav: {
      current: 1,
      pageSize: 10,
      showQuickJumper: true,
      showSizeChanger: true,
      showTotal: total => `总共 ${total} 条`,
      onShowSizeChange: (current, pageSize) => {
        const pagenav = Object.assign({}, this.state.pagenav);
        pagenav.current = current;
        pagenav.pageSize = pageSize;
        this.setState({ pagenav });
        setTimeout(() => {
          this.taskAttendanceComAttendGroupPageForGroup();
        });
      },
      onChange: (page, pageSize) => {
        const pagenav = Object.assign({}, this.state.pagenav);
        pagenav.current = page;
        pagenav.pageSize = pageSize;
        this.setState({ pagenav });
        setTimeout(() => {
          this.taskAttendanceComAttendGroupPageForGroup();
        });
      },
      total: 0
    }
  };

  componentDidMount() {
    this.taskAttendanceComAttendGroupPageForGroup();
  }

  //获取内勤组分页查询
  taskAttendanceComAttendGroupPageForGroup = () => {
    taskAttendanceComAttendGroupPageForGroup({
      pageSize: this.state.pagenav.pageSize,
      pageNumber: this.state.pagenav.current
    }).then(
      response => {
        const pagenav = { ...this.state.pagenav };
        let { data } = response.data;
        data = data.map((val, i) => {
          val.key = i;
          return val;
        });
        pagenav.total = response.data.total;
        this.setState({
          dataSource: data,
          pagenav
        });
      },
      err => {
        console.log(err, 'taskAttendanceComAttendGroupPageForGroup-err');
      }
    );
  };
  //删除内勤组
  taskAttendanceComAttendGroupDelete = (attendGroupId, isFormal) => {
    taskAttendanceComAttendGroupDelete({ attendGroupId, isFormal }).then(
      response => {
        this.taskAttendanceComAttendGroupPageForGroup();
      },
      err => {
        console.log(err, 'taskAttendanceComAttendGroupDelete-err-删除内勤组');
      }
    );
  };

  renderTable = () => {
    const columns = [
      {
        title: '内勤组名称',
        dataIndex: 'attendGroupName',
        key: '1',
        width: 200
      },
      {
        title: '人数',
        dataIndex: 'perCount',
        key: '2',
        width: 60
      },
      {
        title: '类型',
        dataIndex: 'attendType',
        key: '3',
        render: text => {
          return <div>{text}</div>;
        },
        width: 100
      },
      {
        title: '内勤组信息',
        dataIndex: 'shiftDetail',
        key: '4',
        render: text => {
          return <div dangerouslySetInnerHTML={{ __html: text }} />;
        }
      },
      {
        title: '操作',
        dataIndex: 'e',
        key: '5',
        width: 150,
        render: (text, record) => {
          return (
            <div style={{ color: 'rgba(15,113,255,1)' }}>
              <span
                onClick={() => {
                  this.props.history.push(
                    `/attendancemanagement/newattendanceunit/selectionattendancetype?attendGroupId=${
                      record['attendGroupId']
                    }&isFormal=${record['isFormal']}`
                  );
                }}
                style={{ marginRight: 8 }}
              >
                {record.isFormal === '0' ? '继续完善' : '编辑内勤组'}
              </span>
              <span
                onClick={() => {
                  confirm({
                    content: <div>删除该内勤组后不可恢复！请谨慎操作!</div>,
                    okText: '删除',
                    cancelText: '取消',
                    onOk: () => {
                      this.taskAttendanceComAttendGroupDelete(
                        record['attendGroupId'],
                        record['isFormal']
                      );
                    },
                    onCancel() {
                      console.log('Cancel');
                    }
                  });
                }}
              >
                删除
              </span>
            </div>
          );
        }
      }
    ];

    return (
      <Table
        pagination={this.state.pagenav}
        dataSource={this.state.dataSource}
        columns={columns}
        //loading={this.state.loading}
      />
    );
  };

  gotoTask = () => {
    this.props.history.push('/taskmanager/tasklist');
  }

  render() {
    return (
      <div
        className="CreateTask CreateThiftManagement"
        style={{ padding: '0 20px' }}
      >
        <Tabs>
          <TabPane tab="内勤组管理" key="1">
            <Alert
              message={<div>内勤组：适用于企业一般职员、内勤人员，固定排班考勤的人员进行考勤管理；若您需要安排机动性强、或者业务类、保安员类考勤任务，请使用<a onClick={this.gotoTask}>【驻勤管理】</a>功能。
              <p style={{color: '#f00', marginBottom: '0'}}>内勤组新建后，不可编辑规则，只允许进行人员的增减设置。</p></div>}
              type="warning"
              showIcon
              style={{ marginBottom: '15px' }}
            />
            <Button
              onClick={() => {
                //this.setState({ open: true });
                this.props.history.push(
                  '/attendancemanagement/newattendanceunit/selectionattendancetype'
                );
              }}
              className="new-btn"
              type="primary"
            >
              新增内勤组
            </Button>
            {this.renderTable()}
            {/*  选择班次--新增班次 */}
            <AddNewAttendanceUnit
              ok={open => {
                this.setState({ open });
              }}
              cancel={open => {
                this.setState({ open });
              }}
              open={this.state.open}
            />
            <Modal
              title="选择班次生效时间"
              visible={this.state.visible}
              okText="立即生效"
              cancelText="明日生效"
              onOk={() => {
                this.setState({ visible: false });
              }}
              onCancel={() => {
                this.setState({ visible: false });
              }}
              wrapClassName="thiftModal"
            >
              <Icon type="exclamation-circle" />
              若选择“立即生效”，今天相关的任务记录会重新核算！
            </Modal>
          </TabPane>
        </Tabs>
      </div>
    );
  }
}
