import React from "react";
import { Modal, Button } from "antd";
// import { connect } from "dva";

import { messagegetmessagebyid } from "../../../services/api";

// @connect(state => ({
//   fetchingNotices: state.global.fetchingNotices,
//   global: state.global
// }))
class MessageDetail extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      visible: false,
      checkList: {
        addresser: "", //查看消息弹窗的发送人
        sendTime: "", //查看消息弹窗的时间
        title: "", //查看消息弹窗的标题
        content: '', //内容
        id: "" //人员消息关联主键
      }
    };
  }
  componentWillReceiveProps(nextProps) {
    if (
      nextProps.record.id &&
      nextProps.record.id !== this.state.checkList.id && nextProps.visible
    ) {
      
      this.clickHandlerView(nextProps.record);
    }

    if (nextProps.visible) {
      this.setState({ visible: nextProps.visible });
    }
  }

  checkMessageCancel = () => {
    this.setState({
      visible: false,
      checkList: {
        addresser: "", //查看消息弹窗的发送人
        sendTime: "", //查看消息弹窗的时间
        title: "", //查看消息弹窗的标题
        content: '', //内容
        id: "" //人员消息关联主键
      }
    });

    this.props.closeModal();
  };

  // 点击查看展示信息弹窗
  clickHandlerView = record => {
    //消息详情，接收方（new）
    messagegetmessagebyid({
      id: record.id,
      messageType: record.messageType
    }).then(data => {
      // console.log(data.data, "消息详情，接收方（new）");
      if (data.data) {
        this.setState({
          checkList: data.data.messageDetail
        });
        console.log(this.props)
        // this.props.dispatch({
        //   type: "global/fetchNotices"
        // });
      }
    }, (err) => {
      console.log(err);
    });
  };

  render() {
    const { content } = this.state.checkList;
    const fragment = content.replace(/\\n/g, '<br/>');
    return (
      <Modal
        width={700}
        title={
          <div className="message-title clearfix">
            <span>
              来自：<i>{this.state.checkList.senPer?this.state.checkList.senPer:this.state.checkList.addresser}</i>
            </span>
            <span className="title-right" style={{marginLeft: 30}}>{this.state.checkList.sendTime}</span>
            <p>{this.state.checkList.title}</p>
          </div>
        }
        visible={this.state.visible}
        onCancel={this.checkMessageCancel}
        footer={<Button onClick={this.checkMessageCancel}>关闭</Button>}
      >
        <div className="message-content">
          <div
            className="content-theme"
            dangerouslySetInnerHTML={{ __html: fragment }}
          />

          {
           (() => {
            const { enclosureUrl } = this.state.checkList;
            if(!enclosureUrl) return;
            const  annexes = enclosureUrl.split('&&');
            return (
              <div>
                {
                  annexes.length > 0 && annexes[0] &&
                  <header style={{
                    marginTop: 20
                  }}>
                    附件：
                  </header>
                }
                {
                  annexes.map((annex, index) => {
                    if(annex) {
                      // window.open(url);
                      const info = annex.split('||');
                      if(info[0]) {
                        return (<a
                          key={index}
                          style={
                            {
                              marginTop: 10,
                              marginLeft: 10,
                              display: 'block'
                            }
                          }
                          href={info[0]}
                          target="_blank"
                          type="primary"
                        >
                          {info[1]}
                        </a>);
                      }
                        
                      // let link = document.createElement('a');
                      // link.style.display = 'none';
                      // link.href = url;
                      // link.setAttribute('download', `附件${index}`);
                      // document.body.appendChild(link);
                      // link.click();
                    }
                  })
                }
              </div>
            );
           })()
          }
        </div>
      </Modal>
    );
  }
}

export default MessageDetail;
