import React, { Component } from "react";
import { connect } from "dva";

import { Tabs } from "antd";

import ReceiveList from "./ReceiveList";
import SendRecord from "./SendRecord";

import styles from "./less/message.less";

const { TabPane } = Tabs;

@connect(state => ({
  profile: state.profile
}))
export default class Messages extends Component {
  componentDidMount() {}

  handleSubmit = e => {
    e.preventDefault();
    this.props.form.validateFieldsAndScroll((err, values) => {
      if (!err) {
        this.props.dispatch({
          type: "form/submitRegularForm",
          payload: values
        });
      }
    });
  };
  callback = key => {
    // console.log(key);
  };

  render() {
    return (
      <div className={styles.message} style={{paddingTop:'10px'}}>
       <Tabs
          tabBarStyle={{ marginLeft: 24, marginRight: 24 }}
          defaultActiveKey="2"
          onChange={this.callback}
        >
          {/* <TabPane tab="接收列表" key="1">
            <ReceiveList />
          </TabPane> */}
          <TabPane tab="发送记录" key="2">
            <SendRecord />
          </TabPane>
        </Tabs>
      </div>
    );
  }
}
