import React, {PureComponent} from 'react';
import {connect} from 'dva';
import style from "styled-components"
import {Tabs, Select, Input, Button, Table, DatePicker, Icon} from 'antd';
import {Link} from 'dva/router';
import * as api from "../../../services/api";
import PTable from "../../../components/Pro/PTable";
import Drawer from 'react-motion-drawer';

const Option = Select.Option
const {MonthPicker} = DatePicker;

@connect(state => ({
  monitor: state.monitor,
}))
export default class ReportGet extends PureComponent {
  constructor(props, context) {
    super(props, context);
    this.state = {
      type: this.props.match.params.type || 1,//2为查看月报表，1为查看普遍// 报表
      reportId: this.props.match.params.reportId,
      columns: [],//动态表头
      pageParm: {
        reportId: this.props.match.params.reportId,
        reportMonth: "",
        pageNumber: "1",
        pageSize: "5",
      },//分页请求参数
      forceUpdate: false,
      ifDrawerOpen: false,
    };

  }

  /******************************生命周期******************************/

    //查看报表有2种模式，分别为查看月报表，查看普通报表
  componentDidMount = () => {
    let {type, reportId} = this.state;
    this.enterpriseSalaryComReportReportDetail(reportId);
  }
  // 根据报表id获得报表表头
  enterpriseSalaryComReportReportDetail = (reportId) => {
    api.enterpriseSalaryComReportReportDetail({reportId}).then((data) => {

      let columns = data.data.map((val, key) => ({
        title: val.fieldName,
        dataIndex: val.fieldCode,
        key
      }));
      this.setState({columns});
    }, (err) => {
      console.log(err);
    });
  }
  // 查看报表详情
  enterpriseSalaryComReportReportInfo = () => {
    api.enterpriseSalaryComReportReportInfo().then((data) => {
      console.log(data);

    }, (err) => {
      console.log(err);
    });
  }
  /******************************ajax请求******************************/


  /******************************相关事件******************************/

  onMonthPickerChange = (date, dateString) => {
    console.log(date, dateString);
  }
  dateTableChange = (data) => {
    console.log(data);
  }

  drawerOnChange = (ifDrawerOpen) => {
    this.setState({ifDrawerOpen});
  }

  renderTable = () => {
    const dataSource = [{
      key: '1',
      name: '胡彦斌',
      age: 32,
      address: '西湖区湖底公园1号'
    }, {
      key: '2',
      name: '胡彦祖',
      age: 42,
      address: '西湖区湖底公园1号'
    }];
    const columns = [...this.state.columns];
    let newProp = {};
    if (columns.length > 10) {
      columns[0].fixed = "left";
      columns[0].width = 80;
      newProp = {
        scroll: {x: 1400}
      };
    }
    if (columns.length > 14) {
      newProp = {
        scroll: {x: 1600}
      };
    }
    if (columns.length > 20) {
      newProp = {
        scroll: {x: 2000}
      };
    }
    return (
      <PTable
        columns={columns}
        url="enterpriseSalaryComReportReportInfo"
        pageParm={this.state.pageParm}
        dateChange={this.dateTableChange}
        forceUpdate={this.state.forceUpdate}
        {...newProp}
      />
    );
  }

  render() {
    const {type} = this.state;
    return (
      <div>
        <Content>
          {/* 搜索条件面板 */}
          <div className="searchpanel">
            {type === "2" &&
            <div style={{display: "inline-block"}}>
              <span>报表时间：</span>
              <MonthPicker onChange={this.onMonthPickerChange} placeholder="Select month"
                           style={{width: 214, marginRight: 17}}/>
            </div>
            }
            <Button type="primary" onClick={() => this.setState({ifDrawerOpen: true})}>编辑模式</Button>
            <Button style={{marginLeft: 17}}>导出报表</Button>
          </div>
          <Title>2017年10月<span className="split">|</span>实发工资总计<span className="value"> 250,000.00元</span></Title>
          {this.renderTable()}


        </Content>
        <Drawer
          overlayColor="rgba(0, 0, 0,0)"
          right
          open={this.state.ifDrawerOpen}
          noTouchClose
          width={600}
          zIndex={2}
          className="drawer-box"
          onChange={this.drawerOnChange}
        >
          <Export>
            <p className="title">
              导出报表
            </p>

            <div className="item">
              <div className="l">
                导出单月报表:
              </div>
              <MonthPicker onChange={this.onMonthPickerChange} placeholder="Select month"
                           style={{width: 214, marginRight: 8}}/>
              <Button type="primary"><Icon type="download"/>下载报表</Button>
            </div>
            <div className="item">
              <div className="l">
                导出连续报表:
              </div>
              <MonthPicker onChange={this.onMonthPickerChange} placeholder="Select month"
                           style={{width: 214, marginRight: 8}}/>
              <Button type="primary"><Icon type="download"/>下载报表</Button>
            </div>
          </Export>
        </Drawer>
      </div>
    );
  }
}

/************************样式************************/

const Content = style.div`{
  font-size: 14px;
  color: rgba(0,0,0,0.65);
  padding:22px 24px;
  .searchpanel{
     margin-bottom:16px;
  }
  .split{
    margin:0 8px;
  }
  .value{
    color: #0F71FF;
    margin-left: 4px;
  }
}`;

const Opton = style.span`{
  font-size: 12px;
  color: #0F71FF;
  cursor:pointer;
  margin-right:8px;
}`;
const Title = style.div`{
    border: 1px solid #D9D9D9;
    border-radius: 4px;
    height:51px;
    line-height:51px;
    padding:0 16px;
    margin-bottom:16px;
}`;
const Export = style.div`{
  
  .title{
    font-size: 18px;
    color: #333333;
    line-height: 21px;
    padding:19px;
    border:1px solid #E9E9E9;
  }
  .item{
     margin-bottom:24px;
     
    .l{
      width:168px;
      display:inline-block;
      text-align:right;
      margin-right:8px;
    }
    .r{
      
    }
  }
  
}`;
