import React, {PureComponent} from 'react';
import {connect} from 'dva';
import style from "styled-components"
import {Tabs, Select, Input, Button, Table, DatePicker} from 'antd';
import {Link} from 'dva/router';


const Option = Select.Option;
const {MonthPicker} = DatePicker;

@connect(state => ({
  monitor: state.monitor,
}))
export default class MonthReportGet extends PureComponent {
  constructor(props, context) {
    super(props, context);
    this.state = {};

  }

  onMonthPickerChange = (date, dateString) => {
    console.log(date, dateString);
  }


  renderTable = () => {
    const dataSource = [{
      key: '1',
      name: '胡彦斌',
      age: 32,
      address: '西湖区湖底公园1号'
    }, {
      key: '2',
      name: '胡彦祖',
      age: 42,
      address: '西湖区湖底公园1号'
    }];


    const columns = [
      {
        title: '姓名',
        dataIndex: 'name',
        key: 'name',
      },
      {
        title: '工号',
        dataIndex: 'age',
        key: 'age',
      },
      {
        title: '一级部门',
        dataIndex: 'address',
        key: 'address',
      },
      {
        title: '二级部门',
        dataIndex: 'a',
        key: 'a',
      }
      ,
      {
        title: '银行账号',
        dataIndex: 'b',
        key: 'b',
      },
      {
        title: '基本工资',
        dataIndex: 'c',
        key: 'c',
      },
      {
        title: '绩效工资',
        dataIndex: '1',
        key: '1',
      },
      {
        title: '迟到扣款',
        dataIndex: '2',
        key: '2',
      },
      {
        title: '缺勤扣款',
        dataIndex: '3',
        key: '4',
      },
      {
        title: '税前工资',
        dataIndex: '5',
        key: '5',
      },
      {
        title: '计税工资',
        dataIndex: '6',
        key: '6',
      },
      {
        title: '应发工资',
        dataIndex: '7',
        key: '7',
      },
    ];


    return <Table dataSource={dataSource} columns={columns} bordered={true}/>;
  }

  render() {

    return (
      <Content>
        {/* 搜索条件面板 */}
        <div className="searchpanel">
          <span>报表时间：</span>
          <MonthPicker onChange={this.onMonthPickerChange} placeholder="Select month" style={{width: 214}}/>
          <Button type="primary" style={{marginLeft: 17}}>编辑模式</Button>
          <Button style={{marginLeft: 17}}>导出报表</Button>
        </div>
        <Title>2017年10月<span className="split">|</span>实发工资总计<span className="value"> 250,000.00元</span></Title>
        {this.renderTable()}
      </Content>

    );
  }
}

/************************样式************************/

const Content = style.div`{
  font-size: 14px;
  color: rgba(0,0,0,0.65);
  padding:22px 24px;
  .searchpanel{
     margin-bottom:16px;
  }
  .split{
    margin:0 8px;
  }
  .value{
    color: #0F71FF;
    margin-left: 4px;
  }
}`;

const Opton = style.span`{
  font-size: 12px;
  color: #0F71FF;
  cursor:pointer;
  margin-right:8px;
}`;
const Title = style.div`{
    border: 1px solid #D9D9D9;
    border-radius: 4px;
    height:51px;
    line-height:51px;
    padding:0 16px;
    margin-bottom:16px;
}`;
