import React, { Component } from 'react';
import { connect } from 'dva';
import {
  Input,
  Button,
  Form,
  DatePicker,
  Drawer
} from 'antd';
// import Drawer from 'react-motion-drawer';
import moment from 'moment';

import './less/devices.less';
import * as api from "../../../services/api";

const FormItem = Form.Item;
const { TextArea } = Input;
const dateFormat = 'YYYY-MM-DD HH:mm';
@connect(state => ({ profile: state.profile }))
@Form.create()

export default class StorageRecordDrawer extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      open: this.props.visible,//出库入库详情
      equipInOutId: '',//企业设备出入库Id
      currentRow: {
        equipName: '',
        operaDate: '',
        equipType: '',
        operaNum: '',
        remark: '',
        equipNo: '',
        inOutStockType: '',
        equipInOutId: '',
        perName: '',
        equipType_name: '',
        inOutStockType_name: '',
      }
    };
  }
  componentWillReceiveProps(props) {
    this.setState({ open: props.visible });
    if (this.state.equipInOutId !== props.equipInOutId) {
      this.setState({ equipInOutId: props.equipInOutId });
      const equipInOutId = props.equipInOutId;
      api.EnterpriseEquipComEquipInOutGetComEquipInOutById({ equipInOutId }).then((data) => {
        if (data.data[0]) {
          const datas = data.data[0];

          const currentRow = { ...this.state.currentRow };
          for (const key in datas) {
            if (datas.hasOwnProperty(key) === true) {
              currentRow[key] = datas[key];
            }
          }
          this.setState({ currentRow });
        }
      }, (err) => {
        console.log(err);
      });
    }

  }
  hideDrawer = () => {
    this.setState({ open: false });
  }
  render() {
    const formItemLayout = {
      labelCol: {
        xs: {
          span: 24
        },
        sm: {
          span: 7
        }
      },
      wrapperCol: {
        xs: {
          span: 24
        },
        sm: {
          span: 17
        },
        md: {
          span: 17
        }
      }
    };


    const { getFieldDecorator } = this.props.form;
    return (
      <Drawer
        overlayColor="rgba(0, 0, 0,0)"
        placement="right"
        visible={this.state.open}
        width={600}
        zIndex={11}
        destroyOnClose
        title="出库入库"
        onChange={(open) => {
          this.props.onChange(open);
          this.setState({ open });
        }}
        onClose={this.hideDrawer}
      >
        <div>
          <div>
            <Form onSubmit={this.handleSubmit}>
              <FormItem {...formItemLayout} label="设备编号">
                {getFieldDecorator('equipNo', { initialValue: this.state.currentRow.equipNo || " " })(<Input style={{ width: 294 }} disabled />)}
              </FormItem>
              <FormItem {...formItemLayout} label="设备名称:">
                {getFieldDecorator('equipName', { initialValue: this.state.currentRow.equipName || " " })(<Input style={{ width: 294 }} disabled />)}
              </FormItem>
              <FormItem {...formItemLayout} label="设备类型">
                {getFieldDecorator('equipType_name', { initialValue: this.state.currentRow.equipType_name || " " })(<Input style={{ width: 294 }} disabled />)}
              </FormItem>
              <FormItem {...formItemLayout} label="出入库类型">
                {getFieldDecorator('inOutStockType_name', { initialValue: this.state.currentRow.inOutStockType_name || " " })(<Input style={{ width: 294 }} disabled />)}
              </FormItem>
              <FormItem {...formItemLayout} label="出库数量">
                {getFieldDecorator('operaNum', { initialValue: this.state.currentRow.operaNum || " " })(<Input style={{ width: 294 }} disabled />)}
              </FormItem>
              <FormItem {...formItemLayout} label="负责人">
                {getFieldDecorator('perName', { initialValue: this.state.currentRow.perName || " " })(<Input style={{ width: 294 }} disabled />)}
              </FormItem>
              <FormItem {...formItemLayout} label="操作日期">
                {getFieldDecorator('operaDate', { initialValue: moment(this.state.currentRow.operaDate, dateFormat) || " " })(<DatePicker
                  format="YYYY-MM-DD HH:mm" style={{ width: 294 }} disabled />)}
              </FormItem>
              <FormItem {...formItemLayout} label="备注">
                {getFieldDecorator('remark', { initialValue: this.state.currentRow.remark || " " })(<TextArea style={{ width: 294 }} rows={4} disabled />)}
              </FormItem>
            </Form>
          </div>
          <div style={{
              position: 'absolute',
              bottom: 0,
              width: '100%',
              borderTop: '1px solid #e8e8e8',
              padding: '10px 16px',
              textAlign: 'right',
              left: 0,
              background: '#fff',
              borderRadius: '0 0 4px 4px',
            }}>
            <Button type="primary" onClick={this.hideDrawer}>返回</Button>
          </div>
        </div>
      </Drawer>
    );
  }
}
