import React, { Component } from 'react';
import { connect } from 'dva';
import { Input, Button, Form, Modal, message, Tabs } from 'antd';
import PTable from '../../../components/Pro/PTable';
import PSelect from '../../../components/Pro/PSelect';
import './less/devices.less';
import * as api from '../../../services/api';
import AddDevicesDrawer from './AddDevicesDrawer';
import EditDevicesDrawer from './EditDevicesDrawer';
import CheckInOutDrawer from './CheckInOutDrawer';

const FormItem = Form.Item;
const { confirm } = Modal;
const { TabPane } = Tabs;

@connect(state => ({ profile: state.profile }))
@Form.create()
export default class Devices extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      open: false, //添加设备
      open1: false, //编辑设备
      open2: false, //出库入库
      comEquipId: 0, //企业id
      number: 0,
      forceUpdate: false,
      pageParm: {
        equipName: '',
        equipType: '',
        pageSize: '10',
        pageNumber: '1'
      },
      equipName: '',
      equipType: ''
    };
  }

  showDeleteConfirm = (comEquipId, equipName) => {
    const that = this;
    confirm({
      title: `是否删除设备${equipName}，删除后无法找回。是否确认删除？`,
      okText: '确认',
      cancelText: '取消',
      onOk() {
        that.orderDelete(comEquipId);
      },
      onCancel() {
        console.log('Cancel');
      }
    });
  };

  //删除
  orderDelete = comEquipId => {
    api.enterpriseEquipComEquipDeleteComEquipById({ comEquipId }).then(
      () => {
        message.success('删除成功！');
        this.tableUpdate();
      },
      err => {
        // message.error("存在设备出入库记录不允许删除");
        console.log(err);
      }
    );
  };

  //刷新方法
  tableUpdate = () => {
    this.setState({ forceUpdate: true }, () => {
      this.setState({ forceUpdate: false });
    });
  };

  //抽屉视图处理
  changeDrawer = open => {
    this.setState({ open });
  };
  changeDrawer1 = record => {
    this.setState({ comEquipId: record.comEquipId });
    this.setState({ curNum: record.curNum });
    this.setState({ open1: true });
  };
  changeDrawer2 = record => {
    this.setState({ open2: true });
    this.setState({ comEquipId: record.comEquipId });
  };

  //点击搜索
  search = () => {
    const pageParm = { ...this.state.pageParm };
    const { equipName, equipType } = this.state;
    pageParm.equipName = equipName;
    pageParm.equipType = equipType;
    this.setState({ pageParm });
  };
  //选择框的改变
  handleDevicesTypeChange = value => {
    this.setState({ equipType: value.trim() });
  };
  //输入框的书写
  inputSerchDevicesChange = e => {
    this.setState({ equipName: e.target.value.trim() });
  };
  //table 数据变化
  dateTableChange = data => {
    this.setState({ number: data.total });
  };
  //报表类型 change
  pSelectChange = (value, type) => {
    this.setState({ [type]: value });
  };
  //表格渲染
  renderTable = () => {
    const columns = [
      {
        title: '设备编号',
        dataIndex: 'equipNo',
        key: 'equipNo'
      },
      {
        title: '设备名称',
        dataIndex: 'equipName',
        key: 'equipName'
      },
      {
        title: '设备类型',
        dataIndex: 'equipType_name',
        key: 'equipType_name'
      },
      {
        title: '当前库存',
        dataIndex: 'curNum',
        key: 'curNum',
        render: (text, record) => (
          <span>
            {record.curNum}/{record.totalNum}
          </span>
        )
      },
      {
        title: '首次入库时间',
        dataIndex: 'inStockTime',
        key: 'inStockTime'
      },
      {
        title: '设备归还时间',
        dataIndex: 'rk_operaDate',
        key: 'rk_operaDate',
        format: 'YYYY-MM-DD HH:mm'
      },
      {
        title: '最后出库时间',
        dataIndex: 'operaDate',
        key: 'operaDate',
        format: 'YYYY-MM-DD HH:mm'
      },
      {
        title: '操作',
        key: 'action',
        render: (text, record) => (
          <span className="action">
            <span onClick={this.changeDrawer2.bind(this, record)}>
              出库入库
            </span>
            <span onClick={this.changeDrawer1.bind(this, record)}>
              编辑设备
            </span>
            <span
              className="delete"
              onClick={this.showDeleteConfirm.bind(
                this,
                record.comEquipId,
                record.equipName
              )}
            >
              删除设备
            </span>
          </span>
        )
      }
    ];

    return (
      <PTable
        style={{ marginTop: 20 }}
        columns={columns}
        url="enterpriseEquipComEquipListComEquip"
        pageParm={this.state.pageParm}
        dateChange={this.dateTableChange}
        forceUpdate={this.state.forceUpdate}
      />
    );
  };

  render() {
    const formItemLayout = {
      labelCol: {
        xs: {
          span: 24
        },
        sm: {
          span: 7
        }
      },
      wrapperCol: {
        xs: {
          span: 24
        },
        sm: {
          span: 17
        },
        md: {
          span: 17
        }
      }
    };
    const { getFieldDecorator } = this.props.form;
    return (
      <div className="devicesWrapper">
        {/* <h2>共检索到<span>{this.state.number}</span>条数据</h2> */}
        <Tabs>
          <TabPane tab="设备列表" key="1">
            <Form
              className="devicesWrapper-form"
              layout="inline"
              onSubmit={this.handleSubmit}
              style={{ marginLeft: '-13px' }}
            >
              <FormItem {...formItemLayout} label="设备类型">
                {getFieldDecorator('devicesType', {
                  rules: [
                    {
                      required: false
                    }
                  ]
                })(
                  <PSelect
                    type="equipType"
                    onChange={this.pSelectChange}
                    addOption
                    placeholder="全部"
                  />
                )}
              </FormItem>
              <FormItem {...formItemLayout} label="" colon={false}>
                {getFieldDecorator('serchDevices', {
                  // rules: [
                  //   {
                  //     max: 10,
                  //     message: "限制10个字符"
                  //   }
                  // ]
                })(
                  <Input
                    onChange={this.inputSerchDevicesChange}
                    maxLength={10}
                    style={{ width: 214, marginLeft: 16 }}
                    placeholder="搜索设备名称"
                  />
                )}
              </FormItem>
              <FormItem {...formItemLayout} label="" colon={false}>
                <Button id="btnSearch" type="primary" onClick={this.search}>
                  搜索
                </Button>
              </FormItem>
              <br />
              <FormItem {...formItemLayout} label="" colon={false}>
                <Button
                  id="btnAdd"
                  type="primary"
                  onClick={this.changeDrawer.bind(this, true)}
                >
                  添加设备
                </Button>
              </FormItem>
            </Form>
            {this.renderTable()}
            <Modal
              title="删除的设备不可恢复"
              visible={this.state.visible}
              onOk={this.handleModalOk}
              onCancel={this.handleModalCancel}
            >
              <p>确认删除“设备名称”？</p>
            </Modal>
            <AddDevicesDrawer
              onChange={open => {
                this.setState({ open });
              }}
              visible={this.state.open}
              tableUpdate={this.tableUpdate}
            />
            <EditDevicesDrawer
              onChange={open => {
                this.setState({ open1: open });
              }}
              visible={this.state.open1}
              comEquipId={this.state.comEquipId}
              curNum={this.state.curNum}
              tableUpdate={this.tableUpdate}
            />
            <CheckInOutDrawer
              onChange={open => {
                this.setState({ open2: open });
              }}
              visible={this.state.open2}
              comEquipId={this.state.comEquipId}
              tableUpdate={this.tableUpdate}
            />
          </TabPane>
        </Tabs>
      </div>
    );
  }
}
