import React, { Component } from 'react';
import { connect } from 'dva';
import {
  Input,
  Button,
  Form,
  InputNumber,
  message,
  Drawer,
  Modal
} from 'antd';
// import Drawer from 'react-motion-drawer';
import PSelect from "../../../components/Pro/PSelect";
import './less/devices.less';
import * as api from "../../../services/api";


const FormItem = Form.Item;
message.config({
  top: 100,
  right: 5,
  duration: 2,
});

@connect(state => ({ profile: state.profile }))
@Form.create()

export default class AddDevicesDrawer extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      open: this.props.visible,//添加设备
      visibleModal:false //提示框状态
    };
  }

  componentWillReceiveProps(props) {
    this.setState({ open: props.visible });
  }


  //表单提交
  handleAddDeviceSubmit = (e) => {
    e.preventDefault();
    this.props.form.validateFields((err, values) => {
      if (!err) {
        api.countComEquipNo({ equipNo: values.equipNo }).then(() => {
          api.enterpriseEquipComEquipAddComEquip(values).then((data) => {
            message.success(data.msg);
            this.setState({
              open: false,
            });
            this.props.tableUpdate();
            const { setFieldsValue } = this.props.form;
            setFieldsValue({
              equipNo: '',
              equipName: '',
              equipType: '',
            });
          }, (err1) => {
            message.error(err1);
          });
        }, (err2) => {
          message.error(err2);
        });
      }
    });
  }


  //保证数量小于实际库存
  checkNumber = (rule, value, callback) => {
    if (value && !(/^[1-9]\d*$/).test(value)) {
      callback('操作数量格式不正确！');
    } else {
      callback();
    }
  };

  //校验设备编号
  checkNo = (rule, value, callback) => {
    if (value && (/[\u4e00-\u9fa5]+/).test(value)) {
      callback('设备编号格式不正确');
    } else {
      callback();
    }
  };

  hideDrawer = () => {
    // this.setState({ open: false });
    const values = this.props.form.getFieldsValue();
    console.log(values);
    if(values.equipType || values.equipNo || values.equipName || values.curNum){
      console.log(values);
      this.setState({
        visibleModal: true,
      });
    } else {
      this.handleModalOk();
    }
  }

  handleModalOk =() => {
    this.setState({
      open:false,
      visibleModal:false
    });
  }

  handleModalCancel = () =>{
    this.setState({
      visibleModal:false
    });
  }

  render() {
    const formItemLayout = {
      labelCol: {
        xs: {
          span: 24
        },
        sm: {
          span: 7
        }
      },
      wrapperCol: {
        xs: {
          span: 24
        },
        sm: {
          span: 17
        },
        md: {
          span: 17
        }
      }
    };
    const { getFieldDecorator } = this.props.form;

    return (
      <div>
        <Drawer
          overlayColor="rgba(0, 0, 0,0)"
          placement="right"
          title="添加设备"
          visible={this.state.open}
          destroyOnClose
          width={600}
          zIndex={11}
          onChange={(open) => {
            this.props.onChange(open);
            this.setState({ open });
          }}
          onClose={this.hideDrawer}
        >
          <div>
            <div>
              <Form onSubmit={this.handleAddDeviceSubmit}>
                <FormItem {...formItemLayout} label="选择设备类型: ">
                  {getFieldDecorator('equipType', {
                    rules: [
                      {
                        required: true,
                        message: "该字段必填"
                      }
                    ]
                  })(
                    <PSelect style={{ width: 294 }} placeholder="请选择" type="equipType" onChange={this.pSelectChange} deleteAll/>
                    )}
                </FormItem>
                <FormItem {...formItemLayout} label="输入设备编号：">
                  {getFieldDecorator('equipNo', {
                    rules: [
                      {
                        required: true,
                        message: "该字段必填"
                      }, {
                        validator: this.checkNo
                      }
                    ]
                  })(<Input style={{ width: 294 }} placeholder="限制20个字符" maxLength={20} />)}
                </FormItem>
                <FormItem {...formItemLayout} label="输入设备名称">
                  {getFieldDecorator('equipName', {
                    rules: [
                      {
                        required: true,
                        message: "该字段必填"
                      }
                    ]
                  })(<Input style={{ width: 294 }} placeholder="限制10个字符" maxLength={10} />)}
                </FormItem>
                <FormItem {...formItemLayout} label="库存数量">
                  {getFieldDecorator('curNum', {
                    initialValue: 0,
                    rules: [
                      {
                        required: true,
                        message: "该字段必填"
                      }, {
                        validator: this.checkNumber
                      }
                    ]
                  })(<InputNumber style={{ width: 294 }} min={0} max={99999999} />)}
                </FormItem>
              </Form>
            </div>
            <div style={{
              position: 'absolute',
              bottom: 0,
              width: '100%',
              borderTop: '1px solid #e8e8e8',
              padding: '10px 16px',
              textAlign: 'right',
              left: 0,
              background: '#fff',
              borderRadius: '0 0 4px 4px',
            }}>
              <Button onClick={this.hideDrawer}>取消</Button>
              <Button type="primary" style={{ marginLeft: 8 }} htmlType="submit" onClick={this.handleAddDeviceSubmit}>确定</Button>
            </div>
          </div>
        </Drawer>
        <Modal
          title="提示"
          visible={this.state.visibleModal}
          onOk={this.handleModalOk}
          onCancel={this.handleModalCancel}>
          <p>当前信息未保存，是否确认返回？</p>
        </Modal>
      </div>
    );
  }
}
