/**
 * 未签订人员页面
 */
import React, { Component } from "react";
import { connect } from "dva";
import moment from "moment";
import {
  Input,
  Alert,
  Button,
  Form,
  Popover,
  notification,
  Select,
  TreeSelect,
  DatePicker,
} from "antd";
import ExcelButtonOline from "../../../../components/ExcelButtonOline";
import PTable from "../../../../components/Pro/PTable";
import { withRouter } from "dva/router";
import {
  systemComDepartGetDepartTree,
  getPerType,
} from "../../../../services/api";
const Option = Select.Option;
const dateFormat = "YYYY-MM-DD";
@connect((state) => ({
  global: state.global,
}))
@withRouter
@Form.create()
export default class NotSigned extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      open: false, //编辑查看
      number: 0,
      forceUpdate: false,
      pageParm: {
        keyWord: "",
        departIds: "",
        // contractType: "02",
        perType: "",
        pageSize: 10,
        pageNumber: 1,
        // entryDate: "",
        // contractEffect: "",
      },
      keyWord: "",
      departIds: "",
      perType: "",
      // entryDate: "",
      // contractEffect: "",
      canExport: false, //是否可以导出表格
      treeData: [
        //树
        { title: "", key: "" },
      ],
      perTypeList: [], // 人员类别
    };
  }

  componentWillMount() {
    this.departList();
    this.getPerType();
  }
  //选择部门
  departList = () => {
    const recursion = (treeData) => {
      // TreeSelect组件所需值： title， value, key, children disabled
      return treeData.map((item) => {
        item.title = item.departName;
        item.key = item.departId;
        item.value = item.departId;
        // "isExistsDataAuth": "1",  //权限 1有权限 0：没权限
        // item.disabled = item.isExistsDataAuth == 0;
        if (item.childDepart) {
          item.children = recursion(item.childDepart);
        }
        return item;
      });
    };
    // 获取到组织架构列表
    systemComDepartGetDepartTree().then((res) => {
      const DATA = recursion(res.data);
      this.setState({
        treeData: DATA,
        departId: DATA[0].key,
      });
    });
  };
  // 获取人员类别
  getPerType = (cb) => {
    getPerType({ codeType: "perType" }).then(
      (response) => {
        if (response.data) {
          if (response.data) {
            const firstValue = {
              codeType: "perType",
              codeValue: "",
              label: "全部",
            };
            const perTypeList = [firstValue, ...response.data];
            this.setState({
              perTypeList,
              // perType: perTypeList[0].codeValue
            });
            cb && cb();
          }
        }
      },
      (err) => {
        console.log(err);
      }
    );
  };
  //table 数据变化
  dateTableChange = (data) => {
    this.setState({ number: data.total });
  };

  //表格变化
  changeTable = () => {
    this.setState(
      {
        forceUpdate: true,
        open: false,
      },
      () => {
        this.setState({
          forceUpdate: false,
        });
      }
    );
  };
  downLoad = (url) => {
    if (url) {
      window.open(url);
    } else {
      notification.warning({
        message: "该合同未上传附件！",
        description: "请先上传合同文件，方可下载。",
      });
    }
  };
  /**iverry end */
  //搜索
  handleContractSubmit = () => {
    const pageParm = { ...this.state.pageParm };
    let { keyWord, departIds, perType } = this.state;
    pageParm.keyWord = keyWord;
    pageParm.departIds = departIds;
    pageParm.perType = perType;
    // pageParm.entryDate = entryDate;
    // pageParm.expiredMonth = expiredMonth == "" ? "" : parseInt(expiredMonth);
    this.setState(
      {
        pageParm,
        canExport: true,
        forceUpdate: true,
      },
      () => {
        this.setState({
          forceUpdate: false,
        });
      }
    );
  };

  //表格渲染
  renderTable = () => {
    const columns = [
      {
        title: "序号",
        dataIndex: "number",
        key: "number",
      },
      {
        title: "姓名",
        dataIndex: "name",
        key: "name",
      },
      {
        title: "身份证号",
        dataIndex: "idCardNo",
        key: "idCardNo",
      },
      {
        title: "手机号码",
        dataIndex: "mobilePhone",
        key: "mobilePhone",
      },
      {
        title: "部门",
        dataIndex: "departName",
        key: "departName",
      },
      {
        title: "人员类别",
        dataIndex: "perType",
        key: "perType",
      },
      {
        title: "入职日期",
        dataIndex: "entryDate",
        key: "entryDate",
      },
      {
        title: "操作",
        key: "action",
        render: (text, record) => {
          return (
            <span className="action">
              <a
                onClick={() => {
                  this.props.history.push({
                    pathname: `./addContract`,
                    state: {
                      title: "劳务/劳动合同",
                      url: "/contractManagement/laborContract",
                      type: "02",
                      value:{
                        name:record.name,
                        mobilePhone:record.mobilePhone,
                        perId:record.perId
                      },
                      keyTab:'2'
                    },
                  });
                }}
                style={{ color: "#0F71FF" }}
              >
                签订合同
              </a>
            </span>
          );
        },
      },
    ];
    // 导出的合同列表
    const columnsExport = [
      {
        title: "合同类型",
        dataIndex: "contractType_name",
        key: "contractType_name",
        // width: 100,
        render: (text, record) => (
          <span
            style={{
              // width: '100px',
              whiteSpace: "nowrap",
              textOverflow: "ellipsis",
              overflow: "hidden",
            }}
          >
            {record.contractType_name}
          </span>
        ),
      },
      {
        title: "合同名称",
        dataIndex: "contractName",
        key: "contractName",
        render: (text, record) => (
          <Popover
            content={
              <span
                style={{
                  whiteSpace: "normal",
                  width: "300px",
                  display: "inline-block",
                  padding: "10px",
                }}
              >
                {text}
              </span>
            }
            placement="rightTop"
          >
            <div
              style={{
                maxWidth: "300px",
                whiteSpace: "nowrap",
                textOverflow: "ellipsis",
                overflow: "hidden",
                marginTop: "8px",
                marginBottom: "8px",
              }}
            >
              {record.contractName}
            </div>
          </Popover>
        ),
      },
      {
        title: "企业档案编号",
        dataIndex: "comFileNo",
        key: "comFileNo",
        // width: 300,
        render: (text, record) => (
          <span
            style={{
              // width: '300px',
              whiteSpace: "nowrap",
              textOverflow: "ellipsis",
              overflow: "hidden",
            }}
          >
            {record.comFileNo}
          </span>
        ),
      },
      {
        title: "甲方名称",
        dataIndex: "firstPartyName",
        key: "firstPartyName",
        // width: 300,
        render: (text, record) => (
          <span
            style={{
              // width: '300px',
              whiteSpace: "nowrap",
              textOverflow: "ellipsis",
              overflow: "hidden",
            }}
          >
            {record.firstPartyName}
          </span>
        ),
      },
      {
        title: "联系电话",
        dataIndex: "firstPartyTel",
        key: "firstPartyTel",
        // width: 300,
        render: (text, record) => (
          <span
            style={{
              // width: '300px',
              whiteSpace: "nowrap",
              textOverflow: "ellipsis",
              overflow: "hidden",
            }}
          >
            {record.firstPartyTel}
          </span>
        ),
      },
      {
        title: "乙方名称",
        dataIndex: "secondPartyName",
        key: "secondPartyName",
        // width: 300,
        render: (text, record) => (
          <span
            style={{
              // width: '300px',
              whiteSpace: "nowrap",
              textOverflow: "ellipsis",
              overflow: "hidden",
            }}
          >
            {record.secondPartyName}
          </span>
        ),
      },
      {
        title: "联系电话",
        dataIndex: "secondPartyTel",
        key: "secondPartyTel",
        // width: 300,
        render: (text, record) => (
          <span
            style={{
              // width: '300px',
              whiteSpace: "nowrap",
              textOverflow: "ellipsis",
              overflow: "hidden",
            }}
          >
            {record.secondPartyTel}
          </span>
        ),
      },
      {
        title: "合同开始时间",
        dataIndex: "effectStartDate",
        key: "effectStartDate",
        // width: 150,
        render: (text, record) => (
          <span
            style={{
              width: "150px",
              whiteSpace: "nowrap",
              textOverflow: "ellipsis",
              overflow: "hidden",
            }}
          >
            {record.effectStartDate}
          </span>
        ),
      },
      {
        title: "合同结束时间",
        dataIndex: "effectEndDate",
        key: "effectEndDate",
        // width: 150,
        render: (text, record) => (
          <span
            style={{
              width: "150px",
              whiteSpace: "nowrap",
              textOverflow: "ellipsis",
              overflow: "hidden",
            }}
          >
            {record.effectEndDate}
          </span>
        ),
      },
      {
        title: "合同期限",
        dataIndex: "contractPeriod",
        key: "contractPeriod",
        // width: 150,
        render: (text, record) => (
          <span
            style={{
              width: "150px",
              whiteSpace: "nowrap",
              textOverflow: "ellipsis",
              overflow: "hidden",
            }}
          >
            {record.contractPeriod}
          </span>
        ),
      },
      {
        title: "协议签订日期",
        dataIndex: "agreementSignDate",
        key: "agreementSignDate",
        // width: 150,
        render: (text, record) => (
          <span
            style={{
              width: "150px",
              whiteSpace: "nowrap",
              textOverflow: "ellipsis",
              overflow: "hidden",
            }}
          >
            {record.agreementSignDate}
          </span>
        ),
      },
      {
        title: "合同备注信息",
        dataIndex: "remark",
        key: "remark",
        // width: 150,
        render: (text, record) => (
          <span
            style={{
              width: "150px",
              whiteSpace: "nowrap",
              textOverflow: "ellipsis",
              overflow: "hidden",
            }}
          >
            {record.remark}
          </span>
        ),
      },
    ];
    return (
      <div>
        <PTable
          style={{ marginTop: 20 }}
          columns={columns}
          url="pageNoSignContractPer"
          pageParm={this.state.pageParm}
          dateChange={this.dateTableChange}
          forceUpdate={this.state.forceUpdate}
        />
        <PTable
          ref="table"
          style={{ marginTop: 20, display: "none" }}
          columns={columnsExport}
          url="pageNoSignContractPer"
          pageParm={this.state.pageParm}
          dateChange={this.dateTableChange}
          forceUpdate={this.state.forceUpdate}
        />
      </div>
    );
  };

  render() {
    return (
      <div>
        <Alert
          style={{ marginBottom: 15 }}
          message={(() => {
            return (
              <span>
                本页面可查询企业在职，但未签订合同或合同已终止的人员信息；若您需要查看已签订的人员及合同信息，请点击“全部”进行查询。
              </span>
            );
          })()}
          type="warning"
          showIcon
        />
        <div>
          <label style={{ display: "inline-block", marginRight: "16px" }}>
            关键词：
            <Input
              style={{
                width: "240px",
                marginLeft: "16px",
                marginBottom: "16px",
              }}
              value={this.state.keyWord}
              placeholder="姓名/身份证/手机号"
              onChange={(e) => {
                this.setState({
                  keyWord: e.target.value.trim(),
                });
              }}
              maxLength={30}
            />
          </label>
          <label style={{ display: "inline-block", marginRight: "16px" }}>
            所属部门：
            <TreeSelect
              style={{ width: 240 }}
              treeData={this.state.treeData}
              placeholder="请选择部门"
              allowClear
              multiple
              treeDefaultExpandAll
              onChange={(value) => {
                this.setState({
                  departIds: value.length > 0 ? value.join(",") : "",
                });
              }}
            />
          </label>
          <label style={{ display: "inline-block", margin: "0 16px 0" }}>
            人员类别：
            <Select
              style={{ width: 200 }}
              placeholder="请选择"
              onChange={(value) => {
                this.setState({
                  perType: value,
                });
              }}
            >
              {this.state.perTypeList.map((val, key) => {
                return (
                  <Option key={key} value={val.codeValue + ""}>
                    {val.label}
                  </Option>
                );
              })}
            </Select>
          </label>

          {/* <label style={{ display: "inline-block", marginRight: "16px" }}>
            入职日期：
            <DatePicker
              onChange={(date) => {
                const entryDate = moment(date).format(dateFormat);
                this.setState({ entryDate });
              }}
            />
          </label> */}
          <Popover
            content={(() => {
              return <p style={{ padding: 10 }}>搜索后可导出搜索结果</p>;
            })()}
            title="温馨提示："
          >
            <Button
              id="btnSearch"
              type="primary"
              onClick={this.handleContractSubmit}
              style={{ marginBottom: "16px" }}
            >
              搜索
            </Button>
          </Popover>
          <Button
            id="btnSearch"
            onClick={() => {
              const pageParm = {
                ...this.state.pageParm,
                keyWord: "",
                departIds: "",
                perType: "",
                // entryDate: "",
                // contractEffect: "",
              };
              this.setState(
                {
                  pageParm,
                  keyWord: "",
                  departIds: "",
                  perType: "",
                  // entryDate: "",
                  forceUpdate: true,
                  canExport: false,
                  // contractEffect: "",
                },
                () => {
                  this.setState({
                    forceUpdate: false,
                  });
                }
              );
            }}
            style={{ marginBottom: "16px", marginLeft: 15 }}
          >
            重置
          </Button>
        </div>
        <div>
          <Popover
            content={(() => {
              return <p style={{ padding: 10 }}>搜索后可导出搜索结果</p>;
            })()}
            title="温馨提示："
          >
            <ExcelButtonOline
              disabled={!this.state.canExport}
              style={{ marginLeft: "15px" }}
              params={this.state.pageParm}
              apiurl={"/enterprise/com-contract/export-no-sign-contract-per"}
              downloadname={this.props.global.companyInfo.comName + "_合同"}
            >
              导出为excel表格
            </ExcelButtonOline>
          </Popover>
        </div>
        {this.renderTable()}
      </div>
    );
  }
}
