import React, { Component } from "react";
import { Input, Select, LocaleProvider } from "antd";
import PTable from "../../../components/Pro/PTable";
import zh_CN from "antd/lib/locale-provider/zh_CN";
import PersonModal from '../../TaskManange/TaskList/PersonModal';
export default class AttendanceList extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      keyWord: "",
      forceUpdate: false,
      pageParm: {
        comContractId: props.comContractId,
        pageSize: 10,
        pageNumber: 1,
      },
      personCountVisible: false, //驻勤人员管理
      comTaskId: '',
      taskName: '',
      taskStatusValue: '-1'
    };
  }
  render() {
    const columns = [
      {
        title: "驻勤点名称",
        dataIndex: "taskName",
        key: "taskName",
      },
      {
        title: "驻勤点状态",
        dataIndex: "taskEffect",
        key: "taskEffect",
      },
      //   {
      //     title: "驻勤点类型",
      //     dataIndex: "comFileNo",
      //     key: "comFileNo",
      //   },
      {
        title: "驻勤时间",
        dataIndex: "startDate",
        key: "startDate",
        render: (text, record) => {
          return (
            <span>
              {text}~{record.endDate}
            </span>
          );
        },
      },
      {
        title: "服务企业名称",
        dataIndex: "serviceObject",
        key: "serviceObject",
      },
      {
        title: "驻勤人数",
        dataIndex: "perNum",
        key: "perNum",
        render: (text, record) => {
          return (
            <a onClick={() => {
              this.setState({
                taskName: record.taskName,
                comTaskId: record.comTaskId,
                personCountVisible: true
              });
            }}>{text}</a>
          );
        }
      },
    ];
    return (
        
          <>
          <LocaleProvider locale={zh_CN}>

            <PTable
              style={{ marginTop: 20 }}
              columns={columns}
              url="getTaskListByContractId"
              pageParm={this.state.pageParm}
              forceUpdate={this.state.forceUpdate}
            />
          </LocaleProvider>
            {/* 驻勤人员管理 */}
            <PersonModal
              taskName={this.state.taskName}
              visible={this.state.personCountVisible}
              comTaskId={this.state.comTaskId}
              taskStatusValue={this.state.taskStatusValue}
              updateTable={() => {
                this.setState({
                  forceUpdate: true
                }, () => {
                  this.setState({ forceUpdate: false });
                });
              }}
              onCancel={() => {
                this.setState({
                  comTaskId: '',
                  personCountVisible: false
                });
              }}
            />
          </>
    );
  }
}
