import React from 'react';
import { Router, Route, Switch } from 'dva/router';
import {
  LocaleProvider,
  // Spin 
} from 'antd';

// import axios from 'axios';
import zh_CN from 'antd/lib/locale-provider/zh_CN';
// import dynamic from 'dva/dynamic';
import cloneDeep from 'lodash/cloneDeep';
import { getNavData } from './common/nav';
import { getPlainNode } from './utils/utils';
import moment from 'moment';
import 'moment/locale/zh-cn';
moment.locale('zh-cn');
// import styles from './index.less';


function getRouteData(navData, path) {
  if (
    !navData.some(item => item.layout === path) ||
    !navData.filter(item => item.layout === path)[0].children
  ) {
    return null;
  }
  const route = cloneDeep(navData.filter(item => item.layout === path)[0]);
  const nodeList = getPlainNode(route.children);
  return nodeList;
}

function getLayout(navData, path) {
  if (
    !navData.some(item => item.layout === path) ||
    !navData.filter(item => item.layout === path)[0].children
  ) {
    return null;
  }
  /**
   * iverry remack
   * 获取到对应的配置
   */
  const route = navData.filter(item => item.layout === path)[0];
  return {
    component: route.component,
    layout: route.layout,
    name: route.name,
    path: route.path
  };
}

function RouterConfig({ history, app }) {
  /**
   * iverry remark
   * getNavData返回一个包含所有路由配置的数组
   */
  const navData = getNavData(app);
  /**
   * iverry remark
   * 从路由配置中获取到三大模块的组件
   */
  const UserLayout = getLayout(navData, 'UserLayout').component;
  const BasicLayout = getLayout(navData, 'BasicLayout').component;
  const PlatformLoginLayout = getLayout(navData, 'PlatformLoginLayout')
    .component;
  const FromV5Layout = getLayout(navData, 'FromV5Layout')
    .component;

  const passProps = {
    app,
    navData,
    getRouteData: path => {
      return getRouteData(navData, path);
    }
  };

  // 自动跳转到http页面(目前支持http和https的访问，改方法暂时不用)
  // const redirectToHttp = (pathname) => {
  //   // 会议和防控指挥正则
  //   // const pathReg = /(^\/command)|(^\/meeting)/;
  //   const pathReg = /^\/command/;
  //   const { protocol, href, hostname } = window.location;
  //   // 判断是否是https页面
  //   if (protocol == 'https:') {
  //     // 除了会议和防控指挥，全部跳转到http页面
  //     if (!pathReg.test(pathname)) {
  //       // 域名加端口
  //       const hostReg = new RegExp(hostname + '(\:\\d*?)+\/');
  //       let newHost = hostname;
  //       // 测试环境
  //       if (hostname == '114.116.191.105') {
  //         newHost = 'saasweb.test.baibaodun.cn';
  //       }
  //       // 跳转到http页面
  //       window.location.href = href.replace('https', 'http').replace(hostReg, newHost + '/');
  //     }
  //   }
  // }

  const userV5Token=sessionStorage.getItem('userV5Token')
  return (
    <LocaleProvider locale={zh_CN}>
      <Router history={history}>
        <Switch>
  
          <Route
            path='/bbd'
            render={props => {
              // redirectToHttp(props.location.pathname);
              return <PlatformLoginLayout {...props} {...passProps} />;
            }}
          />
          <Route
            path='/user'
            render={props => {
              // redirectToHttp(props.location.pathname);
              return <UserLayout {...props} {...passProps} />;
            }}
          />
          <Route
            path='/'
            render={props => {
              // redirectToHttp(props.location.pathname); 

              //userV5Token为1那就是从v5跳转过来的
              return userV5Token?<FromV5Layout {...props} {...passProps} />:<BasicLayout {...props} {...passProps} />;
            }}
          />
        </Switch>
      </Router>
    </LocaleProvider>
  );
}

export default RouterConfig;
