import {
  getdayStatisticsDataTask,
  getmonthStatisticsDataTask,
  getDepartmentData,
  getAttendRecordDetailTask,
  changeRecordDetailTask
} from '../services/api';

const monthColumns = [
  {
    title: '序号',
    dataIndex: 'perId',
    align: 'center',
    key: 'perId',
    width: 100,
    fixed: 'left'
  },
  {
    title: '姓名',
    dataIndex: 'name',
    align: 'left',
    key: 'name',
    width: 100,
    fixed: 'left'
  },
  {
    title: '手机号',
    dataIndex: 'mobilePhone',
    align: 'left',
    fixed: false,
    key: 'mobilePhone'
  },
  {
    title: '部门',
    dataIndex: 'departName',
    tip: '说明：该人员所在的部门，若本月有调整过部门，则会生成两条记录',
    align: 'left',
    fixed: false,
    key: 'departName',
    width: 300
  },
  {
    title: '统计时段',
    dataIndex: 'attendDateSection',
    tip: '说明：该条数据统计的时间范围',
    align: 'left',
    fixed: false,
    key: 'attendDateSection'
  },
  {
    title: '出勤天数',
    dataIndex: 'attendDays',
    tip: '说明：有排班并且打卡一次的天数',
    align: 'left',
    fixed: false,
    key: 'attendDays'
  },
  {
    title: '休息天数',
    dataIndex: 'restDays',
    tip: '说明：安排休息班的天数',
    align: 'left',
    fixed: false,
    key: 'restDays'
  },
  {
    title: '工作总时长',
    dataIndex: 'workHours',
    tip: '说明：合计工作时长，每轮上下班都打卡才会记录时长，否则记0',
    align: 'left',
    fixed: false,
    key: 'workHours'
  },
  {
    title: '迟到次数',
    dataIndex: 'lateTimes',
    tip: '说明：合计迟到卡次数',
    align: 'left',
    fixed: false,
    key: 'lateTimes'
  },
  {
    title: '迟到总分钟',
    dataIndex: 'totalLateTime',
    tip: '说明：合计迟到总分钟数',
    align: 'left',
    fixed: false,
    key: 'totalLateTime'
  },
  {
    title: '早退次数',
    dataIndex: 'leaveEarlyTimes',
    tip: '说明：合计早退次数',
    align: 'left',
    fixed: false,
    key: 'leaveEarlyTimes'
  },
  {
    title: '早退总分钟',
    dataIndex: 'totalLeaveEarlyTime',
    tip: '说明：合计早退总分钟数',
    align: 'left',
    fixed: false,
    key: 'totalLeaveEarlyTime'
  },
  {
    title: '漏卡次数',
    dataIndex: 'missCardTimes',
    tip: '说明：合计漏卡次数',
    align: 'left',
    fixed: false,
    key: 'missCardTimes'
  },
  {
    title: '缺勤天数',
    dataIndex: 'absenteeismDays',
    tip: '说明：有排班但未打卡一次的天数',
    align: 'left',
    fixed: false,
    key: 'absenteeismDays'
  },
  {
    title: '缺勤时长',
    dataIndex: 'absenceTime',
    tip: '说明：缺勤的班次总时长',
    align: 'left',
    fixed: false,
    key: 'absenceTime'
  },
  {
    title: '请假时长（小时）',
    dataIndex: 'askforleave',
    tip: '说明：合计驻勤请假审批通过的驻勤请假时长',
    align: 'center',
    fixed: false,
    key: 'askforleave',
    children: [
      {
        title: '事假',
        dataIndex: 'absenceLeaveTime',
        tip: false,
        align: 'left',
        fixed: false,
        key: 'absenceLeaveTime'
      },
      {
        title: '病假',
        dataIndex: 'sickLeaveTime',
        tip: false,
        align: 'left',
        fixed: false,
        key: 'sickLeaveTime'
      },
      {
        title: '年假',
        dataIndex: 'yearLeaveTime',
        tip: false,
        align: 'left',
        fixed: false,
        key: 'yearLeaveTime'
      },
      {
        title: '婚假',
        dataIndex: 'marriageLeaveTime',
        tip: false,
        align: 'left',
        fixed: false,
        key: 'marriageLeaveTime'
      },
      {
        title: '调休',
        dataIndex: 'breakOffTime',
        tip: false,
        align: 'left',
        fixed: false,
        key: 'breakOffTime'
      },
      {
        title: '产假',
        dataIndex: 'maternityLeaveTime',
        tip: false,
        align: 'left',
        fixed: false,
        key: 'maternityLeaveTime'
      },
      {
        title: '公假',
        dataIndex: 'publicLeaveTime',
        tip: false,
        align: 'left',
        fixed: false,
        key: 'publicLeaveTime'
      },
      {
        title: '主管假',
        dataIndex: 'chargeLeaveTime',
        tip: false,
        align: 'left',
        fixed: false,
        key: 'chargeLeaveTime'
      }
    ]
  }
];
const dayColumns = [
  {
    title: '序号',
    dataIndex: 'perId',
    align: 'center',
    key: 'perId',
    fixed: 'left'
  },
  {
    title: '姓名',
    dataIndex: 'name',
    align: 'left',
    key: 'name',
    fixed: 'left'
  },
  {
    title: '手机号',
    dataIndex: 'mobilePhone',
    align: 'left',
    fixed: false,
    key: 'mobilePhone'
  },
  {
    title: '部门',
    dataIndex: 'departName',
    tip: '说明：该人员所在的部门，若本月有调整过部门，则会生成两条记录',
    align: 'left',
    fixed: false,
    key: 'departName',
    width: 300
  },
  {
    title: '日期',
    dataIndex: 'attendDate',
    align: 'left',
    fixed: false,
    key: 'attendDate'
  },
  {
    title: '驻勤组',
    dataIndex: 'taskName',
    align: 'left',
    fixed: false,
    key: 'taskName'
  },
  {
    title: '第1轮上班',
    dataIndex: 'firstRoundOnWork',
    align: 'left',
    fixed: false,
    key: 'firstRoundOnWork'
  },
  {
    title: '第1轮下班',
    dataIndex: 'firstRoundOffWork',
    align: 'left',
    fixed: false,
    key: 'firstRoundOffWork'
  },
  {
    title: '第2轮上班',
    dataIndex: 'secondRoundOnWork',
    align: 'left',
    fixed: false,
    key: 'secondRoundOnWork'
  },
  {
    title: '第2轮下班',
    dataIndex: 'secondRoundOffWork',
    align: 'left',
    fixed: false,
    key: 'secondRoundOffWork'
  },
  {
    title: '第3轮上班',
    dataIndex: 'thirdRoundOnWork',
    align: 'left',
    fixed: false,
    key: 'thirdRoundOnWork'
  },
  {
    title: '第3轮下班',
    dataIndex: 'thirdRoundOffWork',
    align: 'left',
    fixed: false,
    key: 'thirdRoundOffWork'
  },
  {
    title: '第4轮上班',
    dataIndex: 'fourthRoundOnWork',
    align: 'left',
    fixed: false,
    key: 'fourthRoundOnWork'
  },
  {
    title: '第4轮下班',
    dataIndex: 'fourthRoundOffWork',
    align: 'left',
    fixed: false,
    key: 'fourthRoundOffWork'
  },
  {
    title: '第5轮上班',
    dataIndex: 'fifthRoundOnWork',
    align: 'left',
    fixed: false,
    key: 'fifthRoundOnWork'
  },
  {
    title: '第5轮下班',
    dataIndex: 'fifthRoundOffWork',
    align: 'left',
    fixed: false,
    key: 'fifthRoundOffWork'
  },
  {
    title: '出勤天数',
    dataIndex: 'attendDays',
    tip: '说明：有排班并且打卡一次的天数',
    align: 'left',
    fixed: false,
    key: 'attendDays'
  },
  {
    title: '休息天数',
    dataIndex: 'restDays',
    tip: '说明：安排休息班的天数',
    align: 'left',
    fixed: false,
    key: 'restDays'
  },
  {
    title: '工作总时长',
    dataIndex: 'workHours',
    tip: '说明：合计工作时长，每轮上下班都打卡才会记录时长，否则记0',
    align: 'left',
    fixed: false,
    key: 'workHours'
  },
  {
    title: '迟到次数',
    dataIndex: 'lateTimes',
    tip: '说明：合计迟到次数',
    align: 'left',
    fixed: false,
    key: 'lateTimes'
  },
  {
    title: '迟到总分钟',
    dataIndex: 'totalLateTime',
    tip: '说明：合计迟到总分钟数',
    align: 'left',
    fixed: false,
    key: 'totalLateTime'
  },
  {
    title: '早退次数',
    dataIndex: 'leaveEarlyTimes',
    tip: '说明：合计早退次数',
    align: 'left',
    fixed: false,
    key: 'leaveEarlyTimes'
  },
  {
    title: '早退总分钟',
    dataIndex: 'totalLeaveEarlyTime',
    tip: '说明：合计早退总分钟数',
    align: 'left',
    fixed: false,
    key: 'totalLeaveEarlyTime'
  },
  {
    title: '漏卡次数',
    dataIndex: 'missCardTimes',
    tip: '说明：合计漏卡次数',
    align: 'left',
    fixed: false,
    key: 'missCardTimes'
  },
  {
    title: '缺勤天数',
    dataIndex: 'absenteeismDays',
    tip: '说明：有排班但未打卡一次的天数',
    align: 'left',
    fixed: false,
    key: 'absenteeismDays'
  },
  {
    title: '缺勤时长',
    dataIndex: 'absenceTime',
    tip: '说明：缺勤的班次总时长',
    align: 'left',
    fixed: false,
    key: 'absenceTime'
  },
  {
    title: '请假时长',
    dataIndex: 'askforleave',
    tip: '说明：合计驻勤请假审批通过的驻勤请假时长',
    align: 'center',
    fixed: false,
    key: 'askforleave',
    children: [
      {
        title: '事假',
        dataIndex: 'absenceLeaveTime',
        tip: false,
        align: 'left',
        fixed: false,
        key: 'absenceLeaveTime'
      },
      {
        title: '病假',
        dataIndex: 'sickLeaveTime',
        tip: false,
        align: 'left',
        fixed: false,
        key: 'sickLeaveTime'
      },
      {
        title: '年假',
        dataIndex: 'yearLeaveTime',
        tip: false,
        align: 'left',
        fixed: false,
        key: 'yearLeaveTime'
      },
      {
        title: '婚假',
        dataIndex: 'marriageLeaveTime',
        tip: false,
        align: 'left',
        fixed: false,
        key: 'marriageLeaveTime'
      },
      {
        title: '调休',
        dataIndex: 'breakOffTime',
        tip: false,
        align: 'left',
        fixed: false,
        key: 'breakOffTime'
      },
      {
        title: '产假',
        dataIndex: 'maternityLeaveTime',
        tip: false,
        align: 'left',
        fixed: false,
        key: 'maternityLeaveTime'
      },
      {
        title: '公假',
        dataIndex: 'publicLeaveTime',
        tip: false,
        align: 'left',
        fixed: false,
        key: 'publicLeaveTime'
      },
      {
        title: '主管假',
        dataIndex: 'chargeLeaveTime',
        tip: false,
        align: 'left',
        fixed: false,
        key: 'chargeLeaveTime'
      }
    ]
  },
  {
    title: '操作',
    dataIndex: 'operation',
    fixed: 'right',
    tip: false,
    align: 'center',
    key: 'operation'
  }
];

export default {
  namespace: 'task',

  state: {
    tags: [],
    monthStatisticsData: {
      data: [],
      columns: monthColumns,
      pagination: {
        pageNumber: 1,
        pageSize: 10,
        total: 0
      }
    },
    dayStatisticsData: {
      data: [],
      columns: dayColumns,
      pagination: {
        pageNumber: 1,
        pageSize: 10,
        total: 0
      }
    },
    departmentData: [],
    detailData: {
      data: [],
      avatar: 'assets/images/avatar.png',
      personalInfo: {
        name: '',
        attendDate: '',
        departName: '',
        attendGroupName: ''
      }
    }
  },

  effects: {
    *getdayStatisticsData({ payload }, { call, put }) {
      let response = {};
      try {
        response = yield call(getdayStatisticsDataTask, payload);
      } catch (err) {
        console.log('error', err);
      }

      if (!response.data) {
        return;
      }

      yield put({
        type: 'dayStatisticsData',
        payload: response.data
      });
    },

    *getmonthStatisticsData({ payload }, { call, put }) {
      let response = {};
      try {
        response = yield call(getmonthStatisticsDataTask, payload);
      } catch (err) {
        console.log('error', err);
      }

      if (!response.data) {
        return;
      }

      yield put({
        type: 'monthStatisticsData',
        payload: response.data
      });
    },

    *getDepartMentData(_, { call, put }) {
      let response = {};
      try {
        response = yield call(getDepartmentData);
      } catch (err) {
        console.log('error', err);
      }
      if (!response.data) {
        return;
      }

      yield put({
        type: 'saveDepartmentData',
        payload: response.data
      });
    },

    *getAttendRecordDetail({ payload }, { call, put }) {
      const {
        perId,
        comTaskId,
        attendDate,
        name,
        departName,
        attendGroupName
      } = payload;
      let response = {};
      try {
        response = yield call(getAttendRecordDetailTask, {
          perId,
          comTaskId,
          attendDate
        });
      } catch (err) {
        console.log('error', err);
      }

      if (!response.data) {
        return;
      }
      yield put({
        type: 'saveAttendRecordDetail',
        payload: {
          data: response.data,
          other: {
            perId,
            comTaskId,
            name,
            departName,
            attendGroupName,
            attendDate
          }
        }
      });
    },

    *changeRecordDetail({ payload }, { call, put }) {
      let response = {};
      try {
        response = yield call(changeRecordDetailTask, payload);
      } catch (err) {
        console.log('error', err);
      }

      if (response.retType !== '0') {
        return;
      }

      const { perId, comTaskId, attendDate } = payload;
      const response1 = yield call(getAttendRecordDetailTask, {
        perId,
        comTaskId,
        attendDate
      });
      if (!response1.data) {
        return;
      }

      yield put({
        type: 'saveAttendRecordDetail',
        payload: {
          data: response1.data
        }
      });
    }
  },

  reducers: {
    dayStatisticsData(state, { payload }) {
      return {
        ...state,
        dayStatisticsData: {
          ...state.dayStatisticsData,
          data: payload.data,
          pagination: {
            pageNumber: payload.pageNumber,
            pageSize: payload.pageSize,
            total: payload.total
          }
        }
      };
    },
    monthStatisticsData(state, { payload }) {
      return {
        ...state,
        monthStatisticsData: {
          ...state.monthStatisticsData,
          data: payload.data,
          pagination: {
            pageNumber: payload.pageNumber,
            pageSize: payload.pageSize,
            total: payload.total
          }
        }
      };
    },
    saveDepartmentData(state, { payload }) {
      return {
        ...state,
        departmentData: payload
      };
    },
    saveAttendRecordDetail(state, { payload }) {
      return {
        ...state,
        detailData: {
          ...state.detailData,
          avatar: payload.data.photoUrl || '',
          data: payload.data.list,
          personalInfo: { ...state.detailData.personalInfo, ...payload.other }
        }
      };
    },
    resetModel() {
      return {
        tags: [],
        departmentData: [],
        monthStatisticsData: {
          data: [],
          columns: monthColumns,
          pagination: {
            pageNumber: 1,
            pageSize: 10,
            total: 0
          }
        },
        dayStatisticsData: {
          data: [],
          columns: dayColumns,
          pagination: {
            pageNumber: 1,
            pageSize: 10,
            total: 0
          }
        },
        detailData: {
          data: [],
          avatar: '',
          personalInfo: {
            name: '',
            attendDate: '',
            departName: '',
            attendGroupName: ''
          }
        }
      };
    }
  }
};
