//防控指挥的事件数据处理
export default {
  namespace: "command",
  state: {
    //事件列表
    eventList: {
      list:[]
    },
    //人员信息
    personList: {
      list: [], //打点的列表数据
      addressList: [], //通讯录存储数据
      selectedId: null, //选中哪一个
    },
    //驻勤信息
    attendanceList: {
      //所有驻勤点页面
      list: [], //打点的列表数据
      typeList: [], //类型查询的驻勤点（保留下来，然后点击此页面的时候，展示已经保存的数据，因为tab页没有重新刷新页面）
      selectedId: null, //选中哪一个
      selectedAttenData: null, //选中的驻勤点要查看人员信息数据
    },
    //地图上的事件
    clearInfoWindow: false, //是否清除地图上的数据
    tabIndex: {
      //存储当前点击的tab是哪一个，用于驻勤点跳到人员，再从人员跳回到驻勤点的事件
      tabIndex1: "2",
      event:{
        tabIndex2: "1",
      },
      attendance: {
        tabIndex2: "1",
      },
      person: {
        tabIndex2: "1",
      },
    },
  },
  effects: {
    /*
     * 事件列表
     */
    *fetchEventList({ payload }, { put }) {//更新所有人员信息数据
      yield put({
        type: "changeEventList",
        payload,
      });
    },
    *setEventSelectIndex({ payload }, { put }) {//设置选中事件信息
      yield put({
        type: "changeEventSelectIndex",
        payload,
      });
    },
    /*
     *人员信息
     */
    *fetchPersonList({ payload }, { put }) {//更新所有人员信息数据
      yield put({
        type: "changePersonList",
        payload,
      });
    },
    *fetchPersonAddressList({ payload }, { put }) {//更新通讯录页面的人员信息
      yield put({
        type: "changePersonAddressList",
        payload,
      });
    },
    *setPersonSelectIndex({ payload }, { put }) {//设置选中人员信息
      yield put({
        type: "changePersonSelectIndex",
        payload,
      });
    },
    /*
     *驻勤信息
     */
    *fetchAllAttendanceList({ payload }, { put }) {//更新所有驻勤点打点数据
      yield put({
        type: "changeAllAttendanceList",
        payload,
      });
    },
    //按类型查询的驻勤点
    *fetchAllAttendanceTypeList({ payload }, { put }) {//按类型查询的驻勤点信息
      yield put({
        type: "changeAllAttendanceTypeList",
        payload,
      });
    },
    *setSelectIndex({ payload }, { put }) {//设置选中哪个驻勤点信息
      yield put({
        type: "changeSelectIndex",
        payload,
      });
    },
    *setSelectedAttenData({ payload }, { put }) {//设置要查看哪个驻勤点的具体人员信息
      yield put({
        type: "changeSelectedAttenData",
        payload,
      });
    },
    /*
     *地图上的事件
     */
    *clearInfoWindow({ payload }, { put }) {//清空地图上的信息窗体
      yield put({
        type: "clearInfoWindowData",
        payload,
      });
    },
    *setTabIndex({ payload }, { put }) {//改变tab页面（包括1跟2）
      yield put({
        type: "changeTabIndex",
        payload,
      });
    },
  },

  reducers: {
    //事件列表
    changeEventList(state, { payload }) {
      return {
        ...state,
        eventList: {
          ...state.eventList,
          list: payload.list || [],
        },
      };
    },
    changeEventSelectIndex(state, { payload }) {
      //当选中事件的时候，要把人员、驻勤点的清空
      return {
        ...state,
        eventList:{
          ...state.eventList,
          selectedId: payload,
        },
        personList: {
          ...state.personList,
          selectedId: null,
        },
        attendanceList: {
          ...state.attendanceList,
          selectedId: null,
        },
      };
    },
    //人员信息
    changePersonList(state, { payload }) {
      return {
        ...state,
        personList: {
          ...state.personList,
          list: payload.list || [],
        },
      };
    },
    changePersonAddressList(state, { payload }) {
      return {
        ...state,
        personList: {
          ...state.personList,
          addressList: payload.addressList || [],
        },
      };
    },
    changePersonSelectIndex(state, { payload }) {
      //当选中人员的时候，要把事件、驻勤点的清空
      return {
        ...state,
        eventList: {
          ...state.eventList,
          selectedId: null,
        },
        personList: {
          ...state.personList,
          selectedId: payload,
        },
        attendanceList: {
          ...state.attendanceList,
          selectedId: null,
        },
      };
    },
    //驻勤信息
    changeAllAttendanceList(state, { payload }) {
      return {
        ...state,
        attendanceList: {
          ...state.attendanceList,
          list: payload.attendanceList || [],
        },
      };
    },
    changeAllAttendanceTypeList(state, { payload }) {
      return {
        ...state,
        attendanceList: {
          ...state.attendanceList,
          typeList: payload || [],
        },
      };
    },
    changeSelectIndex(state, { payload }) {
      return {
        ...state,
        eventList: {
          ...state.eventList,
          selectedId: null,
        },
        personList: {
          ...state.personList,
          selectedId: null,
        },
        attendanceList: {
          ...state.attendanceList,
          selectedId: payload,
        },
      };
    },
    changeSelectedAttenData(state, { payload }) {
      return {
        ...state,
        attendanceList: {
          ...state.attendanceList,
          selectedAttenData: payload,
        },
      };
    },
    /*
     *地图上的事件
     */
    //关掉信息窗体，同时让有选中的点，变成没有选中的（包括人员跟驻勤点）
    clearInfoWindowData(state, { payload }) {
      return {
        ...state,
        eventList: {
          ...state.eventList,
          selectedId: null,
        },
        personList: {
          ...state.personList,
          selectedId: null,
        },
        attendanceList: {
          ...state.attendanceList,
          selectedId: null,
        },
        clearInfoWindow: payload,
      };
    },
    changeTabIndex(state, { payload }) {
      return {
        ...state,
        tabIndex: {
          ...state.tabIndex,
          ...payload,
        },
      };
    },
  },
};
