import React from 'react';
import PropTypes from 'prop-types';
import { Route } from 'dva/router';
import DocumentTitle from 'react-document-title';
import styles from './PlatformLoginLayout.less';
import { domainConfig } from '../utils/config';
/***
 * 百保盾平台嵌套SaaS登录功能，布局
 */
import { connect } from 'dva';
@connect(state => ({
  companyInfo: state.global.companyInfo
}))
class PlatformLoginLayout extends React.PureComponent {
  static childContextTypes = {
    location: PropTypes.object
  };
  getChildContext() {
    const { location } = this.props;
    return { location };
  }
  getPageTitle() {
    const { getRouteData, location } = this.props;
    const { pathname } = location;
    let title = domainConfig.getName(this.props.companyInfo.regProvince);
    getRouteData('getRouteData').forEach(item => {
      if (item.path === pathname) {
        title = `${item.name}`;
      }
    });
    return title;
  }
  render() {
    const { getRouteData } = this.props;
    console.log(getRouteData('FromV5Layout'));
    return (<>
      {getRouteData('FromV5Layout').map(item => (
        <Route
          exact={item.exact}
          key={item.path}
          path={item.path}
          component={item.component}
        />
      ))}
    </>
      // <DocumentTitle title={this.getPageTitle()}>
      //   <div className={styles.PlatformLoginLayout}>

      //   </div>
      // </DocumentTitle>
    );
  }
}

export default PlatformLoginLayout;
