import React, { PureComponent } from "react";
import PropTypes from "prop-types";
import { Form, Input, Button, message } from "antd";
import style from "styled-components";
import PLoading from "./PLoading";
import PCascader from "./PCascader";
import bcx_utils from "../../common/bcx_utils";

const FormItem = Form.Item;
export const formItemLayout2 = {
  labelCol: {
    xs: { span: 24 },
    sm: { span: 3 }
  },
  wrapperCol: {
    xs: { span: 24 },
    sm: { span: 21 },
    md: { span: 21 }
  }
};

/*
//this.props.init 事例
const init = {
  points: [116.396636, 39.869063],
  address: "北京市市辖区东城区-东城区中医药特色健康管理社区",
  area: [110000, 110100, 110101],
};
*/
export default class PMapMarker extends PureComponent {
  state = {
    map: "", //地图
    province: "", //省
    place: "", //地点
    searchResult: "", //地图搜索结果
    showInitialMarker: false,
    param: {
      addressLongitude: this.props.param
        ? this.props.param.addressLongitude
        : "",
      addressLatitude: this.props.param ? this.props.param.addressLatitude : ""
    }
    // loading: true,
    // area: [], //所在区域  省市区
    // address: "", //详细地址
    // points: [0, 0], //坐标
    // ifSearch: false, //是否初始化过地址（根据父组件 init 信息）
    // taskCityName: this.props.taskCityName || ""
  };

  /******************************生命周期******************************/

  componentWillMount = () => {};
  componentDidMount = () => {
    this.__loadMapScript();
  };
  componentWillReceiveProps = (nextProps, newState) => {
    this.setState({
      param: {
        addressLongitude: nextProps.param
          ? nextProps.param.addressLongitude
          : "",
        addressLatitude: nextProps.param ? nextProps.param.addressLatitude : ""
      }
    });
    if(nextProps.param){
      this.setState({
        showInitialMarker:true
      })
    }
  };
  __loadMapScript = () => {
    const script = document.createElement("script");
    script.src =
      "http://webapi.amap.com/maps?v=1.4.4&key=9066916e054aa3083a6f081a2a9f9d7a";
    document.body.appendChild(script);

    const script2 = document.createElement("script");
    script2.src = "http://cache.amap.com/lbs/static/addToolbar.js";
    if (!"AMap" in window) {
      document.body.appendChild(script2);
    }

    this._loading();
  };
  _loading = () => {
    let _this = this;

    function nextStep() {
      return new Promise(resolve => {
        setTimeout(() => {
          resolve("AMap" in window);
        }, 500);
      });
    }

    async function ajaxMap() {
      let ifComplete = false;
      for (var i = 0; i < 10; i++) {
        if (!ifComplete) {
          ifComplete = await nextStep();
        } else {
          if (ifComplete) {
            // console.log("地图初始化中。。。");
            _this.state.param &&
            _this.state.param.addressLongitude != "" &&
            _this.state.param.addressLatitude != ""
              ? _this._initialMap(
                  _this.state.param.addressLongitude,
                  _this.state.param.addressLatitude
                )
              : _this._initialMap();
          } else {
            message.error("网络超时");
          }
        }
      }
    }

    ajaxMap();
  };
  _initialMap = (lng, lat) => {
    const that = this;
    const { AMap } = window;

    let config = {
      resizeEnable: true,
      zoom: 14
    };
    if (lng && lat) {
      config = { ...config, ...{ center: [lng, lat] } };
    }
    var map = new AMap.Map("temporary_map", config);
    this.setState({ map });
    //是否显示初始化的标注
    let showInitialMarker = that.state.showInitialMarker;
    if (showInitialMarker) {
      let marker = new AMap.Marker({
        icon: "http://webapi.amap.com/theme/v1.3/markers/n/mark_r.png",
        position: [lng, lat]
      });
      marker.setMap(map);
    }
  };
  _searchMap = () => {
    this.setState({ showInitialMarker: false });
    const { AMap } = window;
    const that = this;
    let place = this.state.place;
    let province = this.state.province;
    let map = this.state.map;
    AMap.service("AMap.PlaceSearch", function() {
      //回调函数
      //实例化PlaceSearch
      let placeSearch = new AMap.PlaceSearch();
      //TODO: 使用placeSearch对象调用关键字搜索的功能
      placeSearch.search(place, function(status, result) {
        if (status == "no_data" || result.poiList.pois.length == 0) {
          bcx_utils.preventRepeatAsync(callback =>
            callback(resolve => {
              message.warning(`当前搜索地址暂无记录`, 1.5, () => {
                window.setTimeout(() => {
                  resolve();
                }, 500);
              });
            })
          );
          return;
        }
        let searchResult = result.poiList.pois;
        let searchResultTmp = searchResult;
        //查看是否有完全符合的结果
        searchResult.map((item, index) => {
          if (place === item.name) {
            searchResult = [];
            searchResult.push(item);
          }
        });
        let lng = searchResult[0].location.lng;
        let lat = searchResult[0].location.lat;

        //将第一个结果放在input里或者是完全匹配的结果
        const { setFieldsValue } = that.props.form;
        let param = that.state.param;
        param.addressLongitude = searchResult[0].location.lng;
        param.addressLatitude = searchResult[0].location.lat;
        that.setState({ param });
        that.setState({ markers: [] });
        that.setState({ place: searchResult[0].name });
        setFieldsValue({ taskAddress: province + searchResult[0].name });
        that._initialMap(lng, lat);
        that.setState({ searchResult });

        searchResult.map((item, index) => {
          let lng = item.location.lng;
          let lat = item.location.lat;
          that.addMarker(lng, lat, index);
        });
      });
    });
  };
  addMarker = (lng, lat, index) => {
    let searchResult = this.state.searchResult;
    let map = this.state.map;
    let markers = this.state.markers;
    let province = this.state.province;
    let that = this;
    let marker = new AMap.Marker({
      icon: "http://webapi.amap.com/theme/v1.3/markers/n/mark_b.png",
      position: [lng, lat]
    });
    markers.push(marker);
    marker.setMap(map);
    if (index) {
      //点击地图上的打点事件
      marker.on("click", function() {
        // this.props.clickMarker(searchResult)
        let param = that.state.param;
        param.addressLongitude = searchResult[index].location.lng;
        param.addressLatitude = searchResult[index].location.lat;
        that.setState({ param, place: searchResult[index].name });
        this.props.clickMarker(searchResult);
        // const { setFieldsValue } = that.props.form;
        // setFieldsValue({ taskAddress: province + searchResult[index].name });
        // setFieldsValue({
        //   longitudeAndLatitude: [
        //     searchResult[index].location.lng,
        //     searchResult[index].location.lat
        //   ]
        // });
      });
    }
  };

  render() {
    return (
      <div style={{ width: "100%", height: 230, overflow: "hidden" }}>
        <div id="temporary_map" style={{ width: "100%", height: 250 }}></div>
      </div>
    );
  }
}
const GaodeMapContainer = style.div`
  position: relative;
  #gaodeMapContainer{
    width:100%;
    // max-width:398px;
    height:300px;
  }
   #panel {
            position: absolute;
            background-color: white;
            max-height: 90%;
            overflow-y: auto;
            top: 10px;
            right: 10px;
            width: 280px;
            z-index:10;
        }
`;
const AutoComplete = style.div`
  .item{
    display: flex;
    margin-bottom: 14px;
    .label{
     width: 80px;
     line-height: 32px;
    }
    .input{
     flex-grow: 1;
     .ant-cascader-picker{
      display:block;
     }
     &.search{
      margin-right: 18px;
     }
    }
  }
`;
