import React, {PureComponent} from 'react';
import PropTypes from 'prop-types';
import {connect} from 'dva';
// import style from "styled-components";
// import {Tabs, Select} from 'antd';
import {
  Form,
  Input,
  Button
} from "antd";
import style from 'styled-components';
import PLoading from './PLoading'
import PCascader from './PCascader'

const FormItem = Form.Item;
export const formItemLayout2 = {
  labelCol: {
    xs: {span: 24},
    sm: {span: 3}
  },
  wrapperCol: {
    xs: {span: 24},
    sm: {span: 21},
    md: {span: 21}
  }
};
export default class PMapForm2 extends PureComponent {
  state = {
    loading: true,
    area: [],//所在区域
    address: "",//详细地址
  };

  static defaultProps = {}

  static propTypes = {}

  /******************************生命周期******************************/

  componentDidMount = () => {
    this.loadMapScript();
  }
  componentWillUnmount = () => {
    window.AMap = null;
  }

  loadMapScript = () => {
    // 高德地图

    const script = document.createElement("script");
    script.src =
      "http://webapi.amap.com/maps?v=1.4.4&key=9066916e054aa3083a6f081a2a9f9d7a";
    document.body.appendChild(script);

    const script2 = document.createElement("script");
    script2.src =
      "http://cache.amap.com/lbs/static/addToolbar.js";
    document.body.appendChild(script2);

    setTimeout(() => {
      console.log("地图初始化中。。。");
      this.initializeMap();
    }, 1000);
  };


  initializeMap = () => {
    /* const {AMap} = window;
     const map = new AMap.Map('gaodeMapContainer', {
       resizeEnable: true,
       zoom: 11,
       center: [116.397428, 39.90923]
     });*/


    var map = new AMap.Map("gaodeMapContainer", {
      resizeEnable: true
    });


    this.setState({loading: false});


  }


  pCascaderChange = (value, selectedOptions) => {
    this.setState({area: selectedOptions});
  }

  addressChange = ({target: {value}}) => {
    const area = this.changeAdress(this.state.area);

    if (value.length < area.length) {
      return;
    }
    if (!value.includes(area)) {
      return;
    }
    this.setState({address: value.replace(area, '')});

    //搜索地区


  }

  changeAdress = (arr) => {
    return [...arr].reduce((acc, item) => acc += item.label, '');
  }

  search = () => {
    const address = this.changeAdress(this.state.area) + this.state.address;

    const map = new AMap.Map("gaodeMapContainer", {
      resizeEnable: true
    });

    AMap.service(["AMap.PlaceSearch"], function () {
      var placeSearch = new AMap.PlaceSearch({ //构造地点查询类
        pageSize: 5,
        pageIndex: 1,
        city: "010", //城市
        map: map,
        panel: "panel"
      });
      //关键字查询
      placeSearch.search(address, (status, result) => {
        console.log(status, result);
      });
    });

  }

  /******************************ajax请求******************************/

  render() {
    const {loading, area, address} = this.state;
    const areaStr = this.changeAdress(area);
    return (
      <div>
        <AutoComplete>
          <div className="item">
            <div className="label">
              任务地点:
            </div>
            <div className="input">
              <PCascader onChange={this.pCascaderChange} placeholder={"请选择所在区域"}/>
            </div>
          </div>
          <div className="item">
            <div className="label">
              详细地址
            </div>
            <div className="input">
              <Input placeholder={"请填写详细地址"} value={areaStr + address} onChange={this.addressChange}/>
            </div>
            <Button onClick={this.search}>搜索</Button>
          </div>
        </AutoComplete>

        {loading && <PLoading></PLoading>}
        <GaodeMapContainer style={{display: `${loading ? "none" : "block"}`}}>
          <div id="panel"></div>
          <div id="gaodeMapContainer"/>
        </GaodeMapContainer>


      </div>
    );
  }
}
const GaodeMapContainer = style.div`
  position: relative;
  #gaodeMapContainer{
    width:100%;
    // max-width:398px;
    height:300px;
  }
   #panel {
            position: absolute;
            background-color: white;
            max-height: 90%;
            overflow-y: auto;
            top: 10px;
            right: 10px;
            width: 280px;
            z-index:10;
        }
`;
const AutoComplete = style.div`
  .item{
    display: flex;
    margin-bottom: 14px;
    .label{
     width: 80px;
     line-height: 32px;
    }
    .input{
     flex-grow: 1;
     .ant-cascader-picker{
      display:block;
     }
    }
  }
`;
