import PUploadFile from "./PUploadFile"


/**
 *
 * @desc    和 antd form 表单无缝对接，接受 initialValue 等任意值
 *          demo   InitialAuthenticationInformation.js
 * @param   {String} value 初始化的地址
 * @param   {func} onChange(data) 返回文件上传结果。
 * @return
 */
const ppHoc = (WrappedComponent) => {
  return class extends React.Component {

    onChange = (data) => {
      if (Object.prototype.toString.call(data) == "[object Array]") {
        this.props.onChange(data.join(","));
      }
    }


    render() {
      const props = {...this.props};
      const newProps = {};

      //如果不是数组就转换成数组。  因为后台返回的是字符串。而多个文件上传要求的是 数组形式。
      if (Object.prototype.toString.call(props.value) === "[object Array]") {
        newProps.init = props.value;
      } else if (Object.prototype.toString.call(props.value) === "[object String]") {
        newProps.init = props.value.split(",");
      }
      newProps.onResult = this.onChange;

      return <WrappedComponent  {...this.props} {...newProps}/>
    }
  }
}

const PFromUploadFile = ppHoc(PUploadFile);

export default PFromUploadFile;
