import React, { Component } from "react";
import { Modal, Tree, Input, Icon, Select } from "antd";
import "./index.less";
import { getTreeperBydepart } from "../../services/api";

const { TreeNode } = Tree;
const { Search } = Input;
const { Option } = Select;
const children = [];

class PartmentSelect extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      checkable: this.props.checkable || true,
      treeData: [],
      checkedkeys: [],
      visible: true,
      searchValue: "",
      autoExpandParent: true,
      expandedKeys: ["0-0-0", "0-0-1"],
      checkedKeys: ["0-0-0"],
      selectedKeys: []
    };
  }

  componentDidMount() {
    getTreeperBydepart({}).then(
      response => {
        this.setState({ treeData: response.data });
      },
      err => {
        console.log(err, "getTreeperBydepart-err");
      }
    );
  }

  onChange = e => {
    const { value } = e.target;
    this.setState({
      expandedKeys,
      searchValue: value,
      autoExpandParent: true
    });
  };

  onExpand = expandedKeys => {
    this.setState({
      expandedKeys,
      autoExpandParent: false
    });
  };

  onCheck = (checkedKeys, e) => {
    this.setState({ checkedKeys });
  };

  handleCancel = e => {
    this.setState({
      visible: false
    });
  };

  handleOk = e => {
    this.setState({
      visible: false
    });
    this.props.onCheck(this.state.checkedkeys);
  };

  showModal = e => {
    const targetClass = e.target.className;
    if (
      targetClass === "ant-select-selection__rendered" ||
      targetClass === "ant-select-selection__placeholder" ||
      targetClass.indexOf("ant-select-selection--multiple") !== -1
    ) {
      this.setState({ visible: true });
    }

    /*  this.setState({
       visible: true,
     }); */
  };

  renderTreeNodes = () => {
    return this.state.treeData.map(item => {
      if (item.children) {
        return (
          <TreeNode title={item.title} key={item.key} dataRef={item}>
            {this.renderTreeNodes(item.children)}
          </TreeNode>
        );
      }
      return <TreeNode {...item} />;
    });
  };

  render() {
    const { searchValue, expandedKeys, autoExpandParent } = this.state;
    const selectedList = () => {
      return this.state.checkedkeys.map(val => {
        return (
          <div key={val} className="PartmentSelect-list-item">
            <Icon type="user" /> {val}
            <Icon
              onClick={() => {
                const checkedkeys = this.state.checkedkeys.slice();
                const newcheckedkeys = checkedkeys.filter(value => {
                  return val !== value;
                });
                this.setState({ checkedkeys: newcheckedkeys });
              }}
              type="close-circle-o"
            />
          </div>
        );
      });
    };

    return (
      <div onClick={this.showModal}>
        <Select
          dropdownStyle={{ display: "none" }}
          placeholder="请选择"
          mode="multiple"
          value={this.state.checkedkeys}
          onChange={value => {
            console.log(`Selected: ${value}`);
          }}
          style={{ width: "100%" }}
        >
          {children}
        </Select>
        <Modal
          title="选择部门"
          wrapClassName="PartmentSelect"
          closable={false}
          visible={this.state.visible}
          onOk={this.handleOk}
          onCancel={this.handleCancel}
          width={700}
        >
          <div className="PartmentSelect-title">
            <h2>选择：</h2>
            <h2>已选：</h2>
          </div>
          <div className="PartmentSelect-box">
            <div className="PartmentSelect-wrap">
              <Search
                style={{ marginBottom: 8 }}
                placeholder="Search"
                onChange={this.onChange}
              />
              <div className="tree-box">
                <Tree
                  checkable={this.state.checkable}
                  onExpand={this.onExpand}
                  expandedKeys={this.state.expandedKeys}
                  autoExpandParent={this.state.autoExpandParent}
                  onCheck={this.onCheck}
                  checkedKeys={this.state.checkedKeys}
                  selectedKeys={this.state.selectedKeys}
                >
                  {this.renderTreeNodes()}
                </Tree>
              </div>
            </div>
            <div className="PartmentSelect-wrap PartmentSelect-wrap-selected">
              {selectedList()}
            </div>
          </div>
        </Modal>
      </div>
    );
  }
}

export default PartmentSelect;
