import React from "react";
import { List} from "antd";
import classNames from "classnames";
import styles from "./NoticeList.less";

export default function NoticeList({
  data = [],
  onClick,
  searchFor,
  locale,
  emptyText,
  emptyImage
}) {
  if (data.length === 0) {
    return (
      <div>
        <div className={styles.notFound}>
          {emptyImage ? <img src={emptyImage} alt="not found" /> : null}
          <div>{emptyText || locale.emptyText}</div>
        </div>
        <div className={styles.clear}>
          <a onClick={()=>searchFor("message")} style={{borderRight:'1px solid #e8e8e8'}}>查看全部消息</a>
          <a onClick={()=>searchFor("notify")}>查看平台通知</a>
        </div>
      </div>
      
    );
  }
  return (
    <div>
      <List className={styles.list}>
        {data.map((item, i) => {
          const itemCls = classNames(styles.item, {
            [styles.read]: item.read
          });
          return (
            <List.Item
              className={itemCls}
              key={item.key || i}
              onClick={() => onClick(item)}
            >
              <List.Item.Meta
                className={styles.meta}
                avatar={item.avatar ? item.avatar : null}
                title={
                  <div className={styles.title}>
                    {item.title}
                    <div className={styles.extra}>{item.extra}</div>
                  </div>
                }
                description={
                  <div>
                    <div
                      className={styles.description}
                      title={item.description}
                    >
                      {item.sendTime}
                    </div>
                    <div className={styles.datetime}>{item.datetime}</div>
                  </div>
                }
              />
            </List.Item>
          );
        })}
      </List>
      <div className={styles.clear} style={{marginTop: '0'}}>
        <a onClick={()=>searchFor("message")} style={{borderRight:'1px solid #e8e8e8'}}>查看全部消息</a>
        <a onClick={()=>searchFor("notify")}>查看平台通知</a>
      </div>
    </div>
  );
}