import dynamic from "dva/dynamic";

// wrapper of dynamic
const dynamicWrapper = (app, models, component) =>
  dynamic({
    app,
    models: () => models.map(m => import(`../models/${m}.js`)),
    component
  });

export default function(app) {
  return {
    name: "薪酬服务",
    icon: "renshizhaopin",
    path: "salary",
    children: [
      {
        name: "薪酬服务",
        path: "service",
        component: dynamicWrapper(app, [], () =>
          import("../routes/salary/Service")
        )
      },
    ] 
  };
};
