import dynamic from 'dva/dynamic';

// wrapper of dynamic
const dynamicWrapper = (app, models, component) =>
  dynamic({
    app,
    models: () => models.map(m => import(`../models/${m}.js`)),
    component
  });

export const hrManagement = app => {
  return {
    name: '', //五险一金设置
    icon: 'yishebaoguanli',
    path: 'medical',
    children: [
      // {
      //   name: '医社保记录',
      //   path: 'medicalrecord',
      //   component: dynamicWrapper(app, ['profile'], () => import('../routes/Personnel/Medical/MedicalBasic')),
      // },
      {
        name: '',
        title: '五险一金设置',
        path: 'proportion',
        component: dynamicWrapper(app, ['profile'], () =>
          import('../routes/Personnel/Medical/PayBasic')
        )
      },
      {
        name: '',
        title: '五险一金设置',
        path: '/proporset/:schemeId',
        component: dynamicWrapper(app, ['profile'], () =>
          import('../routes/Personnel/Medical/PaySet')
        )
      }
    ]
  };
};
