import dynamic from 'dva/dynamic';

// wrapper of dynamic
const dynamicWrapper = (app, models, component) =>
  dynamic({
    app,
    models: () => models.map(m => import(`../models/${m}.js`)),
    component
  });

export default app => {
  return {
    name: '业务发票',
    icon: 'renshizhaopin',
    path: 'invoice',
    children: [
      {
        name: '业务开票', //购买在线保险 保险商城
        // title: '保险商城',
        path: 'billing',
        component: dynamicWrapper(app, ['invoice'], () =>
          import('../routes/businessInvoice/Invoicing')
        )
      },
      {
        name: '开票明细', //购买在线保险 保险商城
        // title: '保险商城',
        path: 'detail',
        component: dynamicWrapper(app, ['invoice'], () =>
          import('../routes/businessInvoice/Detail')
        )
      },
      {
        name: '发票配置', //购买在线保险 保险商城
        // title: '保险商城',
        path: 'setting',
        component: dynamicWrapper(app, ['invoice'], () =>
          import('../routes/businessInvoice/Setting')
        )
      },
    ]
  };
};