import dynamic from 'dva/dynamic';

// wrapper of dynamic
const dynamicWrapper = (app, models, component) =>
  dynamic({
    app,
    models: () => models.map(m => import(`../models/${m}.js`)),
    component
  });

export const TrainingInstitutionsCoursewareManagement = app => {
  return {
    name: '课件管理',
    icon: 'renshizhaopin',
    path: 'TrainingInstitutionsCoursewareManagement',
    children: [
      {
        name: '课件库管理',
        path: 'CoursewareLibraryManagement',
        component: dynamicWrapper(app, [], () =>
          import('../routes/Training/TrainingInstitutionsCoursewareManagement/CoursewareLibraryManagement')
        )
      }
    ]
  };
};
