import dynamic from 'dva/dynamic';

// wrapper of dynamic
const dynamicWrapper = (app, models, component) =>
  dynamic({
    app,
    models: () => models.map(m => import(`../models/${m}.js`)),
    component
  });

export const TrainingInstitutionsCertificationManage = app => {
  return {
    name: '保安等级证管理',
    icon: 'renshizhaopin',
    path: 'TrainingInstitutionsCertificationManage',
    children: [
      {
        name: '等级证学员管理',
        path: 'students',
        component: dynamicWrapper(app, [], () =>
          import('../routes/Training/TrainingInstitutionsCertificationManage/StudentManagement')
        )
      },
      {
        name: '等级证学员实习审核',
        path: 'internship',
        component: dynamicWrapper(app, [], () =>
          import('../routes/Training/TrainingInstitutionsCertificationManage/Internship')
        )
      },
      {
        name: '等级证开班管理',
        path: 'open-classes',
        component: dynamicWrapper(app, [], () =>
          import('../routes/Training/TrainingInstitutionsCertificationManage/OpenClasses')
        )
      },
      {
        name: '新增班级',
        path: 'open-classes/add',
        component: dynamicWrapper(app, [], () =>
          import('../routes/Training/TrainingInstitutionsCertificationManage/OpenClasses/AddClass')
        )
      },
      {
        name: '人员对比',
        path: 'ResearchersCompared',
        component: dynamicWrapper(app, [], () =>
          import('../routes/Training/TrainingInstitutionsCertificationManage/ResearchersCompared')
        )
      },
      {
        name: '等级证管理',
        path: 'CertificateManagement',
        component: dynamicWrapper(app, [], () =>
          import('../routes/Training/TrainingInstitutionsCertificationManage/CertificateManagement')
        )
      },
      {
        name: '等级证补贴人员管理',
        path: 'comparison',
        component: dynamicWrapper(app, [], () =>
          import('../routes/Training/TrainingInstitutionsCertificationManage/Comparison')
        )
      },
      {
        name: '等级证补贴批次管理',
        path: 'SubsidyManagement',
        component: dynamicWrapper(app, [], () =>
          import('../routes/Training/TrainingInstitutionsCertificationManage/SubsidyManagement')
        )
      },
      {
        name: '等级证课程学习记录',
        path: 'GradeStudyRecord',
        component: dynamicWrapper(app, [], () =>
          import('../routes/Training/TrainingInstitutionsCertificationManage/GradeStudyRecord')
        )
      },
    ]
  };
};
