import dynamic from 'dva/dynamic';

// wrapper of dynamic
const dynamicWrapper = (app, models, component) =>
  dynamic({
    app,
    models: () => models.map(m => import(`../models/${m}.js`)),
    component
  });

export const PrintingCertificate = app => {
  return {
    name: '保安资格证管理',
    icon: 'renshizhaopin',
    path: 'Printing',
    children: [
      {
        name: '资格证学员管理',
        path: 'StudentManagement',
        component: dynamicWrapper(app, [], () =>
          import('../routes/Training/TrainingInstitutionsTrainingManagement/Students')
        )
      },
      {
        name: '自然人资格证报名缴费',
        path: 'SignUp',
        component: dynamicWrapper(app, [], () =>
          import('../routes/Training/TrainingInstitutionsTrainingManagement/SignUp')
        )
      },
      {
        name: '自然人资格证报名缴费新增报名',
        path: 'SignUp/FillIn',
        component: dynamicWrapper(app, [], () =>
          import('../routes/Training/TrainingInstitutionsTrainingManagement/SignUp/FillIn')
        )
      },
      {
        name: '自然人资格证报名缴费下单缴费',
        path: 'SignUp/Pay',
        component: dynamicWrapper(app, [], () =>
          import('../routes/Training/TrainingInstitutionsTrainingManagement/SignUp/Pay')
        )
      },
      {
        name: '资格证考试安排',
        path: 'ExamArrange',
        component: dynamicWrapper(app, [], () =>
          import('../routes/Training/TrainingInstitutionsExamManage/ExamArrange')
        )
      },
      {
        name: '资格证补考人员',
        path: 'RemedialStaff',
        component: dynamicWrapper(app, [], () =>
          import('../routes/Training/TrainingInstitutionsExamManage/RemedialStaff')
        )
      },
      {
        name: '资格证信息查询',
        path: 'PrintingCertificate',
        component: dynamicWrapper(app, [], () =>
          import('../routes/Training/PrintingCertificate/PrintingCertificate')
        )
      },
      {
        name: '资格证补证',
        path: 'SupplementaryEvidence',
        component: dynamicWrapper(app, [], () =>
          import('../routes/Training/SupplementaryEvidence/SupplementaryEvidence')
        )
      },
      {
        name: '资格证打印记录',
        path: 'PrintRecord',
        component: dynamicWrapper(app, [], () =>
          import('../routes/Training/PrintRecord/PrintRecord')
        )
      },
      {
        name: '资格证补贴批次管理',
        path: 'SubsidyBatch',
        component: dynamicWrapper(app, [], () =>
          import('../routes/Training/TrainingInstitutionsCertificationManage/SubsidyBatch')
        )
      },
      {
        name: '资格证比对人员名单',
        path: 'ComparisonPersonnel',
        component: dynamicWrapper(app, [], () =>
          import('../routes/Training/TrainingInstitutionsCertificationManage/ComparisonPersonnel')
        )
      },
      {
        name: '资格证课程学习记录',
        path: 'QualificationStudyRecord',
        component: dynamicWrapper(app, [], () =>
          import('../routes/Training/TrainingInstitutionsCertificationManage/QualificationStudyRecord')
        )
      },
    ]
  };
};
