import dynamic from 'dva/dynamic';

// wrapper of dynamic
const dynamicWrapper = (app, models, component) =>
  dynamic({
    app,
    models: () => models.map(m => import(`../models/${m}.js`)),
    component
  });

export const PoliceDeclare = app => {
  return {
    name: '备案许可申报',
    icon: 'renshizhaopin',
    path: 'PoliceDeclare',
    children: [
      {
        name: '申报列表',
        path: 'DeclarationList',
        component: dynamicWrapper(app, [], () =>
          import('../routes/PoliceDeclare/DeclarationList')
        )
      },
      {
        name: '保安资格证报名',
        path: 'qualifications',
        component: dynamicWrapper(app, ['certificate'], () =>
          import('../routes/PoliceDeclare/Qualifications')
        )
      },
      // {
      //   name: '保安资格证新增',
      //   path: 'qualifications/add',
      //   component: dynamicWrapper(app, ['certificate'], () =>
      //     import('../routes/PoliceDeclare/Qualifications/AddCert')
      //   )
      // },
      // {
      //   name: '保安资格证报名',
      //   path: 'sign-up',
      //   component: dynamicWrapper(app, ['certificate'], () =>
      //     import('../routes/PoliceDeclare/SignUp')
      //   )
      // },
      
      {
        name: '保安资格新增',
        path: 'sign-up/fill-in',
        component: dynamicWrapper(app, [], () =>
          import('../routes/PoliceDeclare/SignUp/FillIn')
        )
      },
      {
        name: '陕西延安保安资格新增',
        path: 'sign-up/sx-fill-in',
        component: dynamicWrapper(app, [], () =>
          import('../routes/PoliceDeclare/SignUp/SXFillIn')
        )
      },
      {
        name: '保安等级证申报',
        path: 'grade-certificate',
        component: dynamicWrapper(app, ['certificate'], () =>
          import('../routes/PoliceDeclare/GradeCertificate')
        )
      },
      {
        name: '新增等级证',
        path: 'grade-certificate/add',
        component: dynamicWrapper(app, ['certificate'], () =>
          import('../routes/PoliceDeclare/GradeCertificate/AddCertificate')
        )
      },
      {
        name: '岗位适应性培训报名',
        path: 'adapt',
        component: dynamicWrapper(app, ['certificate'], () =>
          import('../routes/PoliceDeclare/Adapt')
        )
      },
      {
        name: '新增报名',
        path: 'adapt/add',
        component: dynamicWrapper(app, ['certificate'], () =>
          import('../routes/PoliceDeclare/Adapt/AddAdapt')
        )
      },
      {
        name: '公安机关通知',
        path: 'police-notice',
        component: dynamicWrapper(app, [], () =>
          import('../routes/PoliceDeclare/PoliceNotice')
        )
      }
    ]
  };
};
