import dynamic from 'dva/dynamic';

// wrapper of dynamic
const dynamicWrapper = (app, models, component) =>
  dynamic({
    app,
    models: () => models.map(m => import(`../models/${m}.js`)),
    component
  });

export const InsuranceManagement = app => {
  return {
    name: '企业保险',
    icon: 'renshizhaopin',
    path: 'insurancemanagement',
    children: [
      // iverry
      {
        name: '保险商城', //购买在线保险 保险商城
        // title: '保险商城',
        path: 'insurance-mart',
        component: dynamicWrapper(app, ['insurance'], () =>
          import('../routes/Insurance/InsuranceMart')
        )
      },
      {
        name: '人员投保管理', //保险方案
        path: 'insurance-management',
        component: dynamicWrapper(app, ['insurance'], () =>
          import('../routes/Insurance/InsuranceManagement/insuranceManagement/Management')
        )
      },
      
      {
        name: '保险保单管理',
        path: 'enterpriseinsurance',
        component: dynamicWrapper(app, ['insurance'], () =>
          import('../routes/Insurance/InsuranceManagement/EnterpriseInsurance')
        )
      },
      {
        name: '', //新增线下保险记录
        title: '企业保险',
        path: 'enterpriseinsurance/insurancedetails',
        component: dynamicWrapper(app, ['insurance'], () =>
          import('../routes/Enterprise/Company/InsuranceDetails')
        )
      },
      {
        name: '保险购买', //保险购买
        path: 'insurancepurchase',
        component: dynamicWrapper(app, ['insurance'], () =>
          import('../routes/Insurance/InsuranceManagement/InsurancePurchase')
        )
      },
      {
        name: '保险方案', //保险方案
        path: 'insurancescheme',
        component: dynamicWrapper(app, ['insurance'], () =>
          import('../routes/Insurance/InsuranceManagement/InsuranceScheme')
        )
      },
      {
        name: '保全缴费记录', //保全缴费记录
        path: 'InsurancePreservation',
        component: dynamicWrapper(app, ['insurance'], () =>
          import('../routes/Insurance/InsuranceManagement/InsurancePreservation')
        )
      },
      {
        name: '保险负责人',
        path: 'insurance-officer',
        component: dynamicWrapper(app, ['insurance'], () =>
          import('../routes/Insurance/InsuranceOfficer')
        )
      },
      // {
      //   name: '保险方案书',//保险方案书
      //   path: 'insurancePlan',
      //   component: dynamicWrapper(app, [], () => import('../routes/Insurance/InsuranceManagement/insurancePlan')),
      // },
      {
        name: '市场平安计划书一', //市场平安计划书一
        path: '100000TYX-PA-1',
        component: dynamicWrapper(app, ['insurance'], () =>
          import('../routes/Insurance/InsuranceManagement/100000TYX-PA-1')
        )
      },
      {
        name: '市场平安计划书二', //市场平安计划书二
        path: '100000TYX-PA-2',
        component: dynamicWrapper(app, ['insurance'], () =>
          import('../routes/Insurance/InsuranceManagement/100000TYX-PA-2')
        )
      },
      {
        name: '市场平安计划书三', //市场平安计划书三
        path: '100000TYX-PA-3',
        component: dynamicWrapper(app, ['insurance'], () =>
          import('../routes/Insurance/InsuranceManagement/100000TYX-PA-3')
        )
      },
      {
        name: '市场平安计划书四', //市场平安计划书四
        path: '100000TYX-PA-4',
        component: dynamicWrapper(app, ['insurance'], () =>
          import('../routes/Insurance/InsuranceManagement/100000TYX-PA-4')
        )
      },
      {
        name: '市场平安计划书五', //市场平安计划书五
        path: '100000TYX-PA-5',
        component: dynamicWrapper(app, ['insurance'], () =>
          import('../routes/Insurance/InsuranceManagement/100000TYX-PA-5')
        )
      },
      {
        name: '市场泰康计划书30万', //市场泰康计划书30万
        path: '100000TYX-TK-3',
        component: dynamicWrapper(app, ['insurance'], () =>
          import('../routes/Insurance/InsuranceManagement/100000TYX-TK-3')
        )
      },
      {
        name: '市场泰康计划书40万', //市场泰康计划书40万
        path: '100000TYX-TK-4',
        component: dynamicWrapper(app, ['insurance'], () =>
          import('../routes/Insurance/InsuranceManagement/100000TYX-TK-4')
        )
      },
      {
        name: '市场泰康计划书50万', //市场泰康计划书50万
        path: '100000TYX-TK-5',
        component: dynamicWrapper(app, ['insurance'], () =>
          import('../routes/Insurance/InsuranceManagement/100000TYX-TK-5')
        )
      },
      {
        name: '市场泰康计划书60万', //市场泰康计划书60万
        path: '100000TYX-TK-6',
        component: dynamicWrapper(app, ['insurance'], () =>
          import('../routes/Insurance/InsuranceManagement/100000TYX-TK-6')
        )
      },
      {
        name: '广西平安计划书一', //广西平安计划书一
        path: '450000TYX-PA-1',
        component: dynamicWrapper(app, ['insurance'], () =>
          import('../routes/Insurance/InsuranceManagement/450000TYX-PA-1')
        )
      },
      {
        name: '广西平安计划书二', //广西平安计划书二
        path: '450000TYX-PA-2',
        component: dynamicWrapper(app, ['insurance'], () =>
          import('../routes/Insurance/InsuranceManagement/450000TYX-PA-2')
        )
      },
      {
        name: '广西平安计划书三', //广西平安计划书三
        path: '450000TYX-PA-3',
        component: dynamicWrapper(app, ['insurance'], () =>
          import('../routes/Insurance/InsuranceManagement/450000TYX-PA-3')
        )
      },
      {
        name: '广西平安计划书四', //广西平安计划书四
        path: '450000TYX-PA-4',
        component: dynamicWrapper(app, ['insurance'], () =>
          import('../routes/Insurance/InsuranceManagement/450000TYX-PA-4')
        )
      },
      {
        name: '广西平安计划书五', //广西平安计划书五
        path: '450000TYX-PA-5',
        component: dynamicWrapper(app, ['insurance'], () =>
          import('../routes/Insurance/InsuranceManagement/450000TYX-PA-5')
        )
      },
      {
        name: '广西泰康计划书30万', //广西泰康计划书30万
        path: '450000TYX-TK-3',
        component: dynamicWrapper(app, ['insurance'], () =>
          import('../routes/Insurance/InsuranceManagement/450000TYX-TK-3')
        )
      },
      {
        name: '广西泰康计划书40万', //广西泰康计划书40万
        path: '450000TYX-TK-4',
        component: dynamicWrapper(app, ['insurance'], () =>
          import('../routes/Insurance/InsuranceManagement/450000TYX-TK-4')
        )
      },
      {
        name: '广西泰康计划书50万', //广西泰康计划书50万
        path: '450000TYX-TK-5',
        component: dynamicWrapper(app, ['insurance'], () =>
          import('../routes/Insurance/InsuranceManagement/450000TYX-TK-5')
        )
      },
      {
        name: '广西泰康计划书60万', //广西泰康计划书60万
        path: '450000TYX-TK-6',
        component: dynamicWrapper(app, ['insurance'], () =>
          import('../routes/Insurance/InsuranceManagement/450000TYX-TK-6')
        )
      },
      {
        name: '陕西平安计划书一', //陕西平安计划书一
        path: '610000TYX-PA-1',
        component: dynamicWrapper(app, ['insurance'], () =>
          import('../routes/Insurance/InsuranceManagement/610000TYX-PA-1')
        )
      },
      {
        name: '陕西平安计划书二', //陕西平安计划书二
        path: '610000TYX-PA-2',
        component: dynamicWrapper(app, ['insurance'], () =>
          import('../routes/Insurance/InsuranceManagement/610000TYX-PA-2')
        )
      },
      {
        name: '陕西平安计划书三', //陕西平安计划书三
        path: '610000TYX-PA-3',
        component: dynamicWrapper(app, ['insurance'], () =>
          import('../routes/Insurance/InsuranceManagement/610000TYX-PA-3')
        )
      },
      {
        name: '陕西平安计划书四', //陕西平安计划书四
        path: '610000TYX-PA-4',
        component: dynamicWrapper(app, ['insurance'], () =>
          import('../routes/Insurance/InsuranceManagement/610000TYX-PA-4')
        )
      },
      {
        name: '陕西平安计划书五', //陕西平安计划书五
        path: '610000TYX-PA-5',
        component: dynamicWrapper(app, ['insurance'], () =>
          import('../routes/Insurance/InsuranceManagement/610000TYX-PA-5')
        )
      },
      {
        name: '陕西泰康计划书30万', //陕西泰康计划书30万
        path: '610000TYX-TK-3',
        component: dynamicWrapper(app, ['insurance'], () =>
          import('../routes/Insurance/InsuranceManagement/610000TYX-TK-3')
        )
      },
      {
        name: '陕西泰康计划书40万', //广西泰康计划书40万
        path: '610000TYX-TK-4',
        component: dynamicWrapper(app, ['insurance'], () =>
          import('../routes/Insurance/InsuranceManagement/610000TYX-TK-4')
        )
      },
      {
        name: '陕西泰康计划书50万', //广西泰康计划书50万
        path: '610000TYX-TK-5',
        component: dynamicWrapper(app, ['insurance'], () =>
          import('../routes/Insurance/InsuranceManagement/610000TYX-TK-5')
        )
      },
      {
        name: '陕西泰康计划书60万', //广西泰康计划书60万
        path: '610000TYX-TK-6',
        component: dynamicWrapper(app, ['insurance'], () =>
          import('../routes/Insurance/InsuranceManagement/610000TYX-TK-6')
        )
      }
    ]
  };
};
