import dynamic from 'dva/dynamic';

// wrapper of dynamic
const dynamicWrapper = (app, models, component) =>
  dynamic({
    app,
    models: () => models.map(m => import(`../models/${m}.js`)),
    component
  });

export const HelpCenterPersonnelImport = app => {
  return {
    name: '人员导入指南',
    icon: 'renshizhaopin',
    path: 'HelpCenterPersonnelImport',
    children: [
      {
        name: '人员导入指南',
        path: 'PersonnelImport',
        component: dynamicWrapper(app, [], () =>
          import('../routes/HelpCenter/PersonnelImport/PersonnelImport')
        )
      }
    ]
  };
};
