import dynamic from 'dva/dynamic';

// wrapper of dynamic
const dynamicWrapper = (app, models, component) =>
  dynamic({
    app,
    models: () => models.map(m => import(`../models/${m}.js`)),
    component
  });

export const HelpCenterOperationManual = app => {
  return {
    name: '操作手册',
    icon: 'renshizhaopin',
    path: 'HelpCenterOperationManual',
    children: [
      {
        name: '操作手册',
        path: 'CommonProblems',
        component: dynamicWrapper(app, [], () =>
          import('../routes/HelpCenter/OperationManual/OperationManual')
        )
      }
    ]
  };
};
