import dynamic from 'dva/dynamic';

// wrapper of dynamic
const dynamicWrapper = (app, models, component) =>
  dynamic({
    app,
    models: () => models.map(m => import(`../models/${m}.js`)),
    component
  });

export const HelpCenterGiveUsAdvice = app => {
  return {
    name: '给我们建议',
    icon: 'renshizhaopin',
    path: 'HelpCenterGiveUsAdvice',
    children: [
      {
        name: '给我们建议',
        path: 'GiveUsAdvice',
        component: dynamicWrapper(app, [], () =>
          import('../routes/HelpCenter/GiveUsAdvice/GiveUsAdvice')
        )
      }
    ]
  };
};
