import dynamic from 'dva/dynamic';

// wrapper of dynamic
const dynamicWrapper = (app, models, component) =>
  dynamic({
    app,
    models: () => models.map(m => import(`../models/${m}.js`)),
    component
  });

export const HelpCenterFunctionIntroduction = app => {
  return {
    name: '功能简介',
    icon: 'renshizhaopin',
    path: 'HelpCenterFunctionIntroduction',
    children: [
      {
        name: '功能简介',
        path: 'OrderManagement',
        component: dynamicWrapper(app, [], () =>
          import('../routes/HelpCenter/FunctionIntroduction/FunctionIntroduction')
        )
      }
    ]
  };
};
