import dynamic from 'dva/dynamic';

// wrapper of dynamic
const dynamicWrapper = (app, models, component) =>
  dynamic({
    app,
    models: () => models.map(m => import(`../models/${m}.js`)),
    component
  });

export const HelpCenterDownloadClient = app => {
  return {
    name: '下载客户端',
    icon: 'renshizhaopin',
    path: 'HelpCenterDownloadClient',
    children: [
      {
        name: '下载客户端',
        path: 'DownloadClient',
        component: dynamicWrapper(app, [], () =>
          import('../routes/HelpCenter/DownloadClient/DownloadClient')
        )
      }
    ]
  };
};
