import dynamic from 'dva/dynamic';

// wrapper of dynamic
const dynamicWrapper = (app, models, component) =>
  dynamic({
    app,
    models: () => models.map(m => import(`../models/${m}.js`)),
    component
  });

export const DevicesManagement = app => {
  return {
    name: '设备管理',
    icon: 'shebeiguanli',
    path: 'devicesManagement',
    children: [
      {
        name: '设备列表',
        path: 'devicesList',
        component: dynamicWrapper(app, ['profile'], () =>
          import('../routes/Administrative/DevicesManagement/DevicesList')
        )
      },
      {
        name: '出入库记录',
        path: 'storageRecord',
        component: dynamicWrapper(app, ['profile'], () =>
          import('../routes/Administrative/DevicesManagement/StorageRecord')
        )
      },
      {
        name: '枪支管理',
        path: 'gunControl',
        component: dynamicWrapper(app, ['profile'], () =>
          import('../routes/Administrative/DevicesManagement/GunControl')
        )
      },
      {
        name: '车辆管理',
        path: 'vehicleManage',
        component: dynamicWrapper(app, ['profile'], () =>
          import('../routes/Administrative/DevicesManagement/VehicleManage')
        )
      }
    ]
  };
};
