/**
 * Created by Administrator on 2017/12/18 0018.人事招聘
 */
import dynamic from 'dva/dynamic';

// wrapper of dynamic
const dynamicWrapper = (app, models, component) =>
  dynamic({
    app,
    models: () => models.map(m => import(`../models/${m}.js`)),
    component
  });

export const AttendanceManagement = app => {
  return {
    name: '内勤管理',
    icon: 'kaoqinguanli',
    path: 'attendancemanagement',
    children: [
      {
        name: '班次管理',
        path: 'newshift1',
        component: dynamicWrapper(app, ['monitor'], () =>
          import('../routes/AttendanceManagement/NewShift')
        )
      },
      {
        name: '内勤组管理',
        path: 'newattendanceunit',
        component: dynamicWrapper(app, ['monitor'], () =>
          import('../routes/AttendanceManagement/NewAttendanceUnit')
        )
      },
      {
        name: '', //设置考勤人员
        title: '内勤管理',
        path: 'newattendanceunit/settingupattendance',
        component: dynamicWrapper(app, ['monitor'], () =>
          import('../routes/AttendanceManagement/SettingUpAttendance')
        )
      },
      {
        name: '', //选择考勤类型
        title: '内勤管理',
        path: 'newattendanceunit/selectionattendancetype',
        component: dynamicWrapper(app, ['monitor'], () =>
          import('../routes/AttendanceManagement/SelectionAttendanceType')
        )
      },
      {
        name: '', //排班设置
        title: '内勤管理',
        path: 'schedulesetting',
        component: dynamicWrapper(app, ['monitor'], () =>
          import('../routes/AttendanceManagement/ScheduleSetting')
        )
      },
      {
        name: '', //考勤方式
        title: '内勤管理',
        path: 'newattendanceunit/choosewayattendance',
        component: dynamicWrapper(app, ['monitor'], () =>
          import('../routes/AttendanceManagement/ChooseWayAttendance')
        )
      },
      {
        name: '', //完成
        title: '内勤管理',
        path: 'newattendanceunit/settingcomplete',
        component: dynamicWrapper(app, ['monitor'], () =>
          import('../routes/AttendanceManagement/SettingComplete')
        )
      },
      {
        name: '内勤月报', //考勤月报
        title: '内勤月报',
        path: 'monthstatistics',
        component: dynamicWrapper(app, ['monitor'], () =>
          import('../routes/AttendanceManagement/MonthStatistics')
        )
      },
      {
        name: '内勤日报', // 考勤日报
        title: '内勤日报',
        path: 'daystatistics',
        component: dynamicWrapper(app, ['monitor'], () =>
          import('../routes/AttendanceManagement/DayStatistics')
        )
      }
    ]
  };
};
