import React, { Component } from 'react';
import { Input, Icon, Radio, Checkbox } from 'antd';
import './index.less';

const { Search } = Input;
const RadioGroup = Radio.Group;
const userdata = [
  {
    "title": "测试二部",
    "key": "395149020382625792",
    "treeType": "1",
    "clildren": [
      {
        "title": "李四",
        "key": "393412400792993792",
        "treeType": "2",
        "clildren": null
      }
    ]
  },
  {
    "title": "测试二部",
    "key": "395149020382625792",
    "treeType": "1",
    "clildren": [
      {
        "title": "李四",
        "key": "393412400792993792",
        "treeType": "2",
        "clildren": null
      }
    ]
  },
  {
    "title": "测试一部",
    "key": "395241451308449792",
    "treeType": "1",
    "clildren": [
      {
        "title": "吴天0",
        "key": "10",
        "treeType": "2",
        "clildren": null
      },
      {
        "title": "吴天12",
        "key": "12",
        "treeType": "2",
        "clildren": null
      },
      {
        "title": "吴天8",
        "key": "8",
        "treeType": "2",
        "clildren": null
      },
      {
        "title": "李四",
        "key": "1",
        "treeType": "2",
        "clildren": null
      },
      {
        "title": "吴天6",
        "key": "6",
        "treeType": "2",
        "clildren": null
      }
    ]
  }
];
class SelectUser extends Component {
  constructor(props, context) {
    super(props, context);
    let type = "checkbox";
    if (this.props.type) {
      const typevalue = this.props.type;
      type = typevalue;
    }
    this.generatorAllUser(userdata);
    this.state = {
      searchvalue: '',
      radiovalue: this.props.value || '',
      type,
      currentTree: userdata,
      checkboxValueArr: this.props.value || [],
      navtree: [{ title: "百川信", key: "all", clildren: userdata }],
      alluser: this.allUser,
    };
  }

  componentDidMount() {

  }

  componentWillReceiveProps(state, nextsate) {
    this.setState({ checkboxValueArr: state.value });
  }

  allUser = []
  /* 遍历所有人员用做搜索 */
  generatorAllUser = (data) => {
    data.forEach((val) => {
      if (val.treeType === "2") {
        this.allUser.push(val);
      }
      if (val.treeType === "1") {
        if (val.clildren !== null) {
          this.generatorAllUser(val.clildren);
        }
      }
    });
  }

  /* 搜索 */

  rendeSearchRadio = () => {
    const userlist = this.state.alluser.filter((val) => {
      const param = val;
      if (val.title.indexOf(this.state.searchvalue) !== -1) {
        param.show = "block";
      } else {
        param.show = "none";
      }
      return param;
    });
    return (<RadioGroup onChange={(e) => {
      this.setState({ radiovalue: e.target.value });
      this.props.onSelect(e.target.value);
    }} value={this.state.radiovalue}>
      {userlist.map((val, index) => {
        if (val.treeType === "2") {
          return <Radio key={index} style={{ display: val.show }} className="radioStyle" value={val.key}><i className="usericon" />{val.title}</Radio>;
        }
        return '';
      })}
    </RadioGroup>);
  }

  renderSearchChecked = () => {
    const userlist = this.state.alluser.map((val) => {
      const param = val;
      if (val.title.indexOf(this.state.searchvalue) !== -1) {
        param.show = "block";
      } else {
        param.show = "none";
      }
      return param;
    });
    return (<Checkbox.Group onChange={(value) => {
      this.props.onSelect(value);
      this.setState({ checkboxValueArr: value });
    }} value={this.state.checkboxValueArr}>
      {userlist.map((val, index) => {
        if (val.treeType === "2") {
          return <Checkbox style={{ display: val.show }} key={index} className="radioStyle" value={val.key}><i className="usericon" />{val.title}</Checkbox>;
        }
        return '';
      })}
    </Checkbox.Group>);
  }

  /* 无搜索 */
  renderDepartment = () => {
    return this.state.currentTree.map((val, index) => {
      if (val.treeType === "1") {
        return (<div key={index} className="department-item"><i className="departmenticon" />{val.title}
          <span onClick={() => {
            const navtree = this.state.navtree.slice();
            navtree.push({ title: val.title, key: val.key, clildren: val.clildren });
            this.setState({ currentTree: val.clildren ? val.clildren : [], navtree });
          }} className="lower"><i className="lowevericon" />下级</span></div>);
      }
      return '';
    });
  }

  renderRadio = () => {
    const currentTree = this.state.currentTree.slice();
    const alluser = this.state.alluser.slice();
    const userlist = alluser.map((val) => {
      const param = val;
      param.show = "none";
      currentTree.forEach((val1, index) => {
        if (val1.key === val.key) {
          param.show = "block";
          currentTree.splice(index, 1);
        }
      });
      return param;
    });

    return (<RadioGroup onChange={(e) => {
      this.setState({ radiovalue: e.target.value });
      this.props.onSelect(e.target.value);
    }} value={this.state.radiovalue}>
      {userlist.map((val, index) => {
        if (val.treeType === "2") {
          return <Radio style={{ display: val.show === "block" ? val.show : "none" }} key={index} className="radioStyle" value={val.key}><i className="usericon" />{val.title}</Radio>;
        }
        return '';
      })}
    </RadioGroup>);
  }

  renderChecked = () => {
    const currentTree = this.state.currentTree.slice();
    const alluser = this.state.alluser.slice();
    const userlist = alluser.map((val) => {
      const param = val;
      param.show = "none";
      currentTree.forEach((val1, index) => {
        if (val1.key === val.key) {
          param.show = "block";
          currentTree.splice(index, 1);
        }
      });
      return param;
    });

    return (<Checkbox.Group onChange={(value) => {
      this.setState({ checkboxValueArr: value });
      this.props.onSelect(value);
    }} value={this.state.checkboxValueArr}>
      {userlist.map((val, index) => {

        if (val.treeType === "2") {
          return <Checkbox style={{ display: val.show === "block" ? val.show : "none" }} key={index} className="radioStyle" value={val.key}><i className="usericon" />{val.title}</Checkbox>;
        }
        return '';
      })}
    </Checkbox.Group>);
  }


  render() {
    const { navtree } = this.state;
    return (<div className="SelectUser">
      <Search
        placeholder="请输入搜索内空"
        value={this.state.searchvalue}
        onChange={(e) => { this.setState({ searchvalue: e.target.value, navtree: navtree.slice(0, 1), currentTree: navtree[0].clildren }); }}
        onSearch={value => console.log(value)}
      />
      <div className="nav-partment">
        {navtree.map((val, index) => {
          if ((navtree.length - 1) !== index) {
            return (<span key={index} onClick={() => {
              const navtreenew = navtree.slice(0, index + 1);
              this.setState({
                navtree: navtreenew,
                currentTree: val.clildren
              });
            }} className="nav">{val.title}<Icon type="right" /></span>);
          }

          return <span key={index}>{val.title}</span>;

        })}
        {/*  <span onClick={() => {
          this.setState({
            currentTree: this.state.data
          });
        }} className="nav">百川信</span> <Icon type="right" /> 研发中心*/}</div>
      <div className="list">
        {this.state.searchvalue.trim().length === 0 && this.renderDepartment()}
        {this.state.type === "radio" && this.state.searchvalue.trim().length === 0 ? this.renderRadio() : ''}
        {this.state.type === "checkbox" && this.state.searchvalue.trim().length === 0 ? this.renderChecked() : ''}
        {/* 搜索结果 */}
        {this.state.searchvalue.trim().length > 0 && this.state.type === "radio" ? this.rendeSearchRadio() : ''}
        {this.state.searchvalue.trim().length > 0 && this.state.type === "checkbox" ? this.renderSearchChecked() : ""}
      </div>

    </div>);
  }
}

export default SelectUser;
