/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.zbkj.common.constants.OnePassConstants;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.utils.RedisUtil;
import com.zbkj.common.utils.RestTemplateUtil;
import com.zbkj.common.vo.OnePassLoginVo;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

@Component
public class OnePassUtil {
    @Autowired
    private RestTemplateUtil restTemplateUtil;
    @Autowired
    private RedisUtil redisUtil;

    public String getToken(OnePassLoginVo loginVo) {
        boolean exists = this.redisUtil.exists(StrUtil.format((CharSequence)"one_pass_token_{}", (Object[])new Object[]{loginVo.getSecret()}));
        if (exists) {
            Object token = this.redisUtil.get(StrUtil.format((CharSequence)"one_pass_token_{}", (Object[])new Object[]{loginVo.getSecret()}));
            return token.toString();
        }
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"account", (Object)loginVo.getAccount());
        map.add((Object)"secret", (Object)loginVo.getSecret());
        JSONObject jsonObject = this.postFrom("https://sms.crmeb.net/api/user/login", (MultiValueMap<String, Object>)map, null);
        String accessToken = "";
        Long expiresIn = 0L;
        accessToken = "Bearer-".concat(jsonObject.getJSONObject("data").getString("access_token"));
        expiresIn = jsonObject.getJSONObject("data").getLong("expires_in");
        expiresIn = expiresIn - CrmebDateUtil.getTime();
        this.redisUtil.set(StrUtil.format((CharSequence)"one_pass_token_{}", (Object[])new Object[]{loginVo.getSecret()}), (Object)accessToken, expiresIn, TimeUnit.SECONDS);
        return accessToken;
    }

    public void removeToken(OnePassLoginVo loginVo) {
        boolean exists = this.redisUtil.exists(StrUtil.format((CharSequence)"one_pass_token_{}", (Object[])new Object[]{loginVo.getSecret()}));
        if (exists) {
            this.redisUtil.delete(new String[]{StrUtil.format((CharSequence)"one_pass_token_{}", (Object[])new Object[]{loginVo.getSecret()})});
        }
    }

    public JSONObject postFrom(String url, MultiValueMap<String, Object> param, Map<String, String> header) {
        String result = this.restTemplateUtil.postFromUrlencoded(url, param, header);
        return this.checkResult(result);
    }

    private JSONObject checkResult(String result) {
        if (StringUtils.isBlank((CharSequence)result)) {
            throw new CrmebException("\u4e00\u53f7\u901a\u5e73\u53f0\u63a5\u53e3\u5f02\u5e38\uff0c\u6ca1\u4efb\u4f55\u6570\u636e\u8fd4\u56de\uff01");
        }
        JSONObject jsonObject = null;
        try {
            jsonObject = JSONObject.parseObject((String)result);
        }
        catch (Exception e) {
            throw new CrmebException("\u4e00\u53f7\u901a\u5e73\u53f0\u63a5\u53e3\u5f02\u5e38\uff01");
        }
        if (OnePassConstants.ONE_PASS_ERROR_CODE.equals(jsonObject.getInteger("status"))) {
            throw new CrmebException("\u4e00\u53f7\u901a\u5e73\u53f0\u63a5\u53e3" + jsonObject.getString("msg"));
        }
        return jsonObject;
    }

    public HashMap<String, String> getCommonHeader(String accessToken) {
        HashMap header = CollUtil.newHashMap();
        header.put("Authorization", accessToken);
        return header;
    }
}

