/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zbkj.common.model.order.OrderInvoice;
import com.zbkj.common.model.order.OrderInvoiceDetail;
import com.zbkj.common.response.OrderInvoiceResponse;
import com.zbkj.service.dao.OrderInvoiceDao;
import com.zbkj.service.service.OrderInvoiceDetailService;
import com.zbkj.service.service.OrderInvoiceService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderInvoiceServiceImpl
extends ServiceImpl<OrderInvoiceDao, OrderInvoice>
implements OrderInvoiceService {
    @Resource
    private OrderInvoiceDao dao;
    @Autowired
    private OrderInvoiceDetailService orderInvoiceDetailService;

    @Override
    public List<OrderInvoiceResponse> findByOrderNo(String orderNo) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(OrderInvoice::getOrderNo, (Object)orderNo);
        List invoiceList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)invoiceList)) {
            return new ArrayList<OrderInvoiceResponse>();
        }
        List<Integer> invoiceIdList = invoiceList.stream().map(OrderInvoice::getId).collect(Collectors.toList());
        List<OrderInvoiceDetail> invoiceDetailList = this.orderInvoiceDetailService.findInInvoiceIdList(invoiceIdList);
        return invoiceList.stream().map(invoice -> {
            OrderInvoiceResponse response = new OrderInvoiceResponse();
            BeanUtils.copyProperties((Object)invoice, (Object)response);
            List detailList = invoiceDetailList.stream().filter(e -> e.getInvoiceId().equals(invoice.getId())).collect(Collectors.toList());
            response.setDetailList(detailList);
            return response;
        }).collect(Collectors.toList());
    }
}

