/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.bcx.BcxProductMenu;
import com.zbkj.common.model.product.ProductCategory;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.BcxProductMenuRequest;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.response.BcxProductMenuResponse;
import com.zbkj.common.utils.RedisUtil;
import com.zbkj.common.utils.SecurityUtil;
import com.zbkj.common.vo.BcxProductMenuTree;
import com.zbkj.common.vo.LoginUserVo;
import com.zbkj.service.dao.BcxProductMenuDao;
import com.zbkj.service.service.BcxProductMenuService;
import com.zbkj.service.service.ProductCategoryService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BcxProductMenuServiceImpl
extends ServiceImpl<BcxProductMenuDao, BcxProductMenu>
implements BcxProductMenuService {
    @Resource
    private BcxProductMenuDao dao;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private ProductCategoryService productCategoryService;

    @Override
    public BcxProductMenu queryById(Integer id) {
        return (BcxProductMenu)this.dao.selectById(id);
    }

    @Override
    public PageInfo<BcxProductMenu> queryPagedList(BcxProductMenu request, PageParamRequest pageParamRequest) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(BcxProductMenu::getId, (Object)request.getId());
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        List sources = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)sources)) {
            return CommonPage.copyPageInfo((Page)page, (List)CollUtil.newArrayList((Object[])new BcxProductMenu[0]));
        }
        List<BcxProductMenu> result = this.transform2target(sources);
        return CommonPage.copyPageInfo((Page)page, result);
    }

    private List<BcxProductMenu> transform2target(List<BcxProductMenu> sources) {
        ArrayList<BcxProductMenu> result = new ArrayList<BcxProductMenu>();
        for (BcxProductMenu source : sources) {
            BcxProductMenu target = new BcxProductMenu();
            BeanUtils.copyProperties((Object)source, (Object)target);
            result.add(target);
        }
        return result;
    }

    @Override
    public Boolean create(BcxProductMenuRequest bcxProductMenuRequest) {
        LoginUserVo loginUserVo = SecurityUtil.getLoginUserVo();
        if (this.checkExist(bcxProductMenuRequest.getName(), bcxProductMenuRequest.getPid())) {
            throw new CrmebException("\u83dc\u5355\u5df2\u5b58\u5728");
        }
        this.verifyProductMenuWhenUpsert(bcxProductMenuRequest);
        BcxProductMenu bcxProductMenu = new BcxProductMenu();
        BeanUtils.copyProperties((Object)bcxProductMenuRequest, (Object)bcxProductMenu);
        bcxProductMenu.setId(null);
        bcxProductMenu.setCreatedBy(loginUserVo.getUser().getId());
        bcxProductMenu.setUpdatedBy(loginUserVo.getUser().getId());
        boolean success = this.save(bcxProductMenu);
        if (success) {
            this.redisUtil.delete(new String[]{"productMenuList"});
        }
        return success;
    }

    private boolean checkExist(String name, Integer pid) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(BcxProductMenu::getPid, (Object)pid);
        lqw.eq(BcxProductMenu::getName, (Object)name);
        BcxProductMenu bcxProductMenu = (BcxProductMenu)this.dao.selectOne((Wrapper)lqw);
        return ObjectUtil.isNotNull((Object)bcxProductMenu) ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Boolean update(BcxProductMenuRequest bcxProductMenuRequest) {
        LoginUserVo loginUserVo = SecurityUtil.getLoginUserVo();
        this.verifyProductMenuWhenUpsert(bcxProductMenuRequest);
        BcxProductMenu bcxProductMenu = new BcxProductMenu();
        BeanUtils.copyProperties((Object)bcxProductMenuRequest, (Object)bcxProductMenu);
        bcxProductMenu.setUpdatedBy(loginUserVo.getUser().getId());
        boolean success = this.updateById(bcxProductMenu);
        if (success) {
            this.redisUtil.delete(new String[]{"productMenuList"});
        }
        return success;
    }

    private void verifyProductMenuWhenUpsert(BcxProductMenuRequest bcxProductMenu) {
        if (!bcxProductMenu.getLevel().equals(1) && bcxProductMenu.getPid().equals(0)) {
            throw new CrmebException("\u5b50\u7ea7\u83dc\u5355\uff0c\u7236\u7ea7ID\u4e0d\u80fd\u4e3a0");
        }
        Integer categoryId = bcxProductMenu.getCategoryId();
        ProductCategory category = (ProductCategory)this.productCategoryService.getById(categoryId);
        if (category != null && category.getLevel() != 1) {
            throw new CrmebException("\u53ea\u80fd\u5173\u8054\u5230\u4e00\u7ea7\u5546\u54c1\u5206\u7c7b");
        }
    }

    @Override
    public Boolean delete(Integer id) {
        List<BcxProductMenu> menuList;
        BcxProductMenu menu = (BcxProductMenu)this.getById(id);
        if (menu == null) {
            throw new CrmebException("\u6ca1\u6709\u627e\u5230\u8be5\u83dc\u5355");
        }
        if (menu.getLevel() < 3 && CollUtil.isNotEmpty(menuList = this.findAllChildListByPid(menu.getId(), menu.getLevel()))) {
            throw new CrmebException("\u8bf7\u5148\u5220\u9664\u5b50\u7ea7\u5206\u7c7b");
        }
        boolean success = this.removeById(id);
        if (success) {
            this.redisUtil.delete(new String[]{"productMenuList"});
        }
        return success;
    }

    @Override
    public List<BcxProductMenu> findAllChildListByPid(Integer pid, Integer level) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(BcxProductMenu::getPid, (Object)pid);
        if (level.equals(2)) {
            return this.dao.selectList((Wrapper)lqw);
        }
        List menuList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)menuList)) {
            return menuList;
        }
        List pidList = menuList.stream().map(BcxProductMenu::getId).collect(Collectors.toList());
        lqw.clear();
        lqw.in(BcxProductMenu::getPid, pidList);
        List thirdLevelList = this.dao.selectList((Wrapper)lqw);
        menuList.addAll(thirdLevelList);
        return menuList;
    }

    @Override
    public List<BcxProductMenuResponse> getCacheTree(Integer type) {
        if (this.redisUtil.exists("productMenuList").booleanValue()) {
            List tree = (List)this.redisUtil.get("productMenuList");
            return tree.stream().filter(m -> m.getType().equals(type)).collect(Collectors.toList());
        }
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        List menu = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)menu)) {
            return CollUtil.newArrayList((Object[])new BcxProductMenuResponse[0]);
        }
        List<Integer> cateList = menu.stream().map(BcxProductMenu::getCategoryId).collect(Collectors.toList());
        Map<Integer, ProductCategory> cateMap = this.productCategoryService.getMapByIdList(cateList);
        List voList = menu.stream().map(e -> {
            BcxProductMenuResponse cacheVo = new BcxProductMenuResponse();
            BeanUtils.copyProperties((Object)e, (Object)cacheVo);
            if (cacheVo.getCategoryId() != null && cacheVo.getCategoryId() > 0 && cateMap.get(cacheVo.getCategoryId()) != null) {
                cacheVo.setCategoryName(((ProductCategory)cateMap.get(cacheVo.getCategoryId())).getName());
            }
            return cacheVo;
        }).collect(Collectors.toList());
        BcxProductMenuTree menuTree = new BcxProductMenuTree(voList);
        List tree = menuTree.buildTree();
        this.redisUtil.set("productMenuList", (Object)tree);
        return tree.stream().filter(m -> m.getType().equals(type)).collect(Collectors.toList());
    }
}

