package com.zbkj.service.service.bcx;

import com.baomidou.mybatisplus.extension.service.IService;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.model.bcx.BcxPlatformFeeConfig;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.bcx.BcxPlatformFeeConfigRequest;

import java.math.BigDecimal;

/**
 * 平台服务费-配置表 服务接口
 */
public interface BcxPlatformFeeConfigService extends IService<BcxPlatformFeeConfig> {

    BcxPlatformFeeConfig queryById(Integer id);

    BcxPlatformFeeConfig queryByProductId(Integer id);

    BcxPlatformFeeConfig queryBySkuId(Integer id);

    BcxPlatformFeeConfig queryByMerId(Integer merId);

    BcxPlatformFeeConfig queryByAnyId(Integer merId, Integer productId, Integer skuId);

    PageInfo<BcxPlatformFeeConfig> queryPagedList(BcxPlatformFeeConfig request,
                                                  PageParamRequest pageParamRequest);

    Boolean create(BcxPlatformFeeConfigRequest bcxPlatformFeeConfig);

    Boolean update(BcxPlatformFeeConfigRequest bcxPlatformFeeConfig);

    Boolean delete(Integer id);

    BigDecimal calcSellPlatformFee(BcxPlatformFeeConfig config, BigDecimal totalPrice, Integer payNum);

    BigDecimal calcLeasePlatformFee(BcxPlatformFeeConfig config, BigDecimal totalPrice, Integer payNum);

    BigDecimal calcInstalmentPlatformFee(BcxPlatformFeeConfig config, BigDecimal totalPrice, Integer payNum, Integer period);

    BigDecimal calcPlatformFee(BcxPlatformFeeConfig platFeeConfig, Integer specType, BigDecimal payPrice, Integer payNum, Integer instalmentPeriod);

    Integer calcPlatformFeePriority(BcxPlatformFeeConfig platFeeConfig, Integer specType);
}
