package com.zbkj.service.service.bcx;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.bcx.BcxFapiaoTitle;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.bcx.BcxFapiaoTitleRequest;
import com.zbkj.service.dao.bcx.BcxFapiaoTitleDao;
import com.zbkj.service.service.UserService;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.validation.Validator;
import java.util.ArrayList;
import java.util.List;

/**
 * 发票抬头表 服务实现类
 */
@Service
public class BcxFapiaoTitleServiceImpl extends ServiceImpl<BcxFapiaoTitleDao, BcxFapiaoTitle> implements BcxFapiaoTitleService {

    @Resource
    private BcxFapiaoTitleDao dao;
    @Resource
    private UserService userService;
    @Resource
    private Validator validator;

    @Override
    public BcxFapiaoTitle queryById(Integer id) {
        Integer userId = userService.getUserIdException();
        BcxFapiaoTitle title = dao.selectById(id);
        if (!userId.equals(title.getUid())) {
            throw new CrmebException("找不到该抬头");
        }
        return title;
    }

    @Override
    public PageInfo<BcxFapiaoTitle> queryPagedList(PageParamRequest pageParamRequest) {
        Integer userId = userService.getUserIdException();
        LambdaQueryWrapper<BcxFapiaoTitle> lqw = new LambdaQueryWrapper<>();
        lqw.eq(BcxFapiaoTitle::getUid, userId);
        Page<BcxFapiaoTitle> page = PageHelper.startPage(pageParamRequest.getPage(), pageParamRequest.getLimit());
        List<BcxFapiaoTitle> sources = dao.selectList(lqw);
        if (CollUtil.isEmpty(sources)) {
            return CommonPage.copyPageInfo(page, CollUtil.newArrayList());
        }
        List<BcxFapiaoTitle> result = transform2target(sources);
        return CommonPage.copyPageInfo(page, result);
    }

    private List<BcxFapiaoTitle> transform2target(List<BcxFapiaoTitle> sources) {
        List<BcxFapiaoTitle> result = new ArrayList<>();
        for (BcxFapiaoTitle source : sources) {
            BcxFapiaoTitle target = new BcxFapiaoTitle();
            BeanUtils.copyProperties(source, target);
            result.add(target);
        }
        return result;
    }

    @Override
    public Boolean create(BcxFapiaoTitleRequest request) {
        Integer userId = userService.getUserIdException();
        validateParam(request);
        BcxFapiaoTitle title = new BcxFapiaoTitle();
        BeanUtils.copyProperties(request, title);
        title.setUid(userId);
//        if (title.getIsDefault()) {
//            setDefaultTitle(0);
//        }
        return save(title);
    }

    public void validateParam(BcxFapiaoTitleRequest request) {
        if (request.getTitleType() == 0 && request.getFapiaoType() == 1) {
            throw new CrmebException("个人只能开增值税普通发票");
        }
        if (request.getTitleType() == 1) {//企业
            if (request.getFapiaoType() == 0) {//普通
                validator.validate(request, BcxFapiaoTitleRequest.CompanyPlainGroup.class);
            } else {
                validator.validate(request, BcxFapiaoTitleRequest.CompanyDedicatedGroup.class);
            }
        }
    }

    @Override
    public Boolean update(BcxFapiaoTitleRequest request) {
        Integer userId = userService.getUserIdException();
        validateParam(request);
        BcxFapiaoTitle title = queryById(request.getId());//校验本人
        BeanUtils.copyProperties(request, title);
        title.setUid(userId);
//        if (title.getIsDefault()) {
//            setDefaultTitle(title.getId());
//        }
        return updateById(title);
    }

    @Override
    public Boolean delete(Integer id) {
        queryById(id);//校验本人
        return removeById(id);
    }

    public void setDefaultTitle(Integer titleId) {
        Integer userId = userService.getUserIdException();
        LambdaUpdateWrapper<BcxFapiaoTitle> luw = new LambdaUpdateWrapper<>();
        luw.set(BcxFapiaoTitle::getIsDefault, false);
        luw.eq(BcxFapiaoTitle::getUid, userId);
        luw.ne(BcxFapiaoTitle::getId, titleId);
        dao.update(null, luw);
    }
}
