package com.zbkj.service.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.model.bcx.BcxProductMenu;
import com.zbkj.common.request.BcxProductMenuRequest;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.response.BcxProductMenuResponse;
import com.zbkj.common.vo.MyRecord;

import java.util.List;

/**
 * 商城商品菜单 服务接口
 */
public interface BcxProductMenuService extends IService<BcxProductMenu> {

    BcxProductMenu queryById(Integer id);
    PageInfo<BcxProductMenu> queryPagedList(BcxProductMenu request,
                                            PageParamRequest pageParamRequest);
    Boolean create(BcxProductMenuRequest bcxProductMenu);
    Boolean update(BcxProductMenuRequest bcxProductMenu);
    Boolean delete(Integer id);

    List<BcxProductMenu> findAllChildListByPid(Integer pid, Integer level);

    List<BcxProductMenuResponse> getCacheTree(Integer type);
}
